package ru.yandex.chemodan.app.djfs.core.util;

import java.util.LinkedHashMap;
import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonNull;
import ru.yandex.commune.json.JsonNumber;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;

/**
 * @author eoshch
 */
public class JsonUtils {
    public static JsonValue value() {
        return JsonNull.NULL;
    }

    public static JsonValue value(@Nullable String value) {
        if (value == null) {
            return JsonNull.NULL;
        }
        return JsonString.valueOf(value);
    }

    public static JsonValue value(long value) {
        return JsonNumber.valueOf(value);
    }

    public static JsonValue value(@Nullable Long value) {
        if (value == null) {
            return JsonNull.NULL;
        }
        return JsonNumber.valueOf(value);
    }

    public static JsonValue value(int value) {
        return JsonNumber.valueOf(value);
    }

    public static JsonValue value(@Nullable Integer value) {
        if (value == null) {
            return JsonNull.NULL;
        }
        return JsonNumber.valueOf(value);
    }

    public static JsonArray array(JsonValue... values) {
        return array(Cf.wrap(values));
    }

    public static JsonArray array(List<JsonValue> values) {
        return new JsonArray(values);
    }

    public static JsonObjectBuilder objectBuilder() {
        return new JsonObjectBuilder();
    }

    public static class JsonObjectBuilder {
        private LinkedHashMap<String, JsonValue> values = new LinkedHashMap<>();

        private JsonObjectBuilder() {
        }

        public JsonObjectBuilder addNull(String key) {
            this.values.put(key, JsonUtils.value());
            return this;
        }

        public JsonObjectBuilder add(String key, @Nullable String value) {
            this.values.put(key, JsonUtils.value(value));
            return this;
        }

        public JsonObjectBuilder add(String key, int value) {
            this.values.put(key, JsonUtils.value(value));
            return this;
        }

        public JsonObjectBuilder add(String key, @Nullable Integer value) {
            this.values.put(key, JsonUtils.value(value));
            return this;
        }

        public JsonObjectBuilder add(String key, long value) {
            this.values.put(key, JsonUtils.value(value));
            return this;
        }

        public JsonObjectBuilder add(String key, @Nullable Long value) {
            this.values.put(key, JsonUtils.value(value));
            return this;
        }

        public JsonObjectBuilder add(String key, JsonValue value) {
            this.values.put(key, value);
            return this;
        }

        public JsonObjectBuilder add(Tuple2<String, Long> value) {
            this.values.put(value._1, JsonUtils.value(value._2));
            return this;
        }

        public JsonObjectBuilder addArray(String key, ListF<JsonValue> values) {
            this.values.put(key, JsonUtils.array(values));
            return this;
        }

        public JsonObjectBuilder addArray(String key, JsonValue... value) {
            this.values.put(key, JsonUtils.array(value));
            return this;
        }

        public JsonObjectBuilder addAll(JsonObjectBuilder other) {
            for (Tuple2<String, JsonValue> entry : other.toMap().entries()) {
                this.add(entry._1, entry._2);
            }
            return this;
        }

        public JsonObject toJsonObject() {
            return new JsonObject(values);
        }

        public MapF<String, JsonValue> toMap() {
            return Cf.wrap(values);
        }
    }
}
