package ru.yandex.chemodan.app.djfs.core.util;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;

public final class StreamUtils {

    public static <T> Stream<ListF<T>> batches(Stream<T> stream, int batchSize) {
        return batchSize <= 0
               ? Stream.of(stream.collect(Collectors.toCollection(Cf::arrayList)))
               : StreamSupport.stream(new BatchSpliterator<>(stream.spliterator(), batchSize), stream.isParallel());
    }

    private static class BatchSpliterator<E> implements Spliterator<ListF<E>> {

        private final Spliterator<E> base;
        private final int batchSize;

        public BatchSpliterator(Spliterator<E> base, int batchSize) {
            this.base = base;
            this.batchSize = batchSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ListF<E>> action) {
            final ListF<E> batch = Cf.arrayListWithCapacity(batchSize);
            for (int i=0; i < batchSize && base.tryAdvance(batch::add); i++)
                ;
            if (batch.isEmpty())
                return false;
            action.accept(batch);
            return true;
        }

        @Override
        public Spliterator<ListF<E>> trySplit() {
            if (base.estimateSize() <= batchSize)
                return null;
            final Spliterator<E> splitBase = this.base.trySplit();
            return splitBase == null ? null
                                     : new BatchSpliterator<>(splitBase, batchSize);
        }

        @Override
        public long estimateSize() {
            final double baseSize = base.estimateSize();
            return baseSize == 0 ? 0
                                 : (long) Math.ceil(baseSize / (double) batchSize);
        }

        @Override
        public int characteristics() {
            return base.characteristics();
        }
    }
}
