package ru.yandex.chemodan.app.djfs.core.util;

import java.nio.ByteBuffer;
import java.util.UUID;

import ru.yandex.misc.codec.Hex;
import ru.yandex.misc.digest.Md5;

/**
 * @author eoshch
 */
public final class UuidUtils {
    public static UUID from(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public static UUID fromHex(String value) {
        return from(Hex.decode(value));
    }

    public static UUID from(String dashSeparated) {
        return UUID.fromString(dashSeparated);
    }

    public static String toHexString(UUID uuid) {
        return uuid.toString().replace("-", "");
    }

    public static String randomToHexString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static UUID md5AsUuid(String anything) {
        return from(Md5.A.digest(anything).getBytes());
    }
}
