package ru.yandex.chemodan.app.djfs.core.util;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.SafeCloseable;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;

/**
 * @author eoshch
 */
public class YcridUtils {
    public static SafeCloseable setThreadLocal(String ycrid) {
        YandexCloudRequestIdHolder.set(ycrid);
        return YandexCloudRequestIdHolder::remove;
    }

    public static Option<String> getPlatform() {
        return YandexCloudRequestIdHolder.getO().filterMap(x -> Cf.wrap(StringUtils.split(x, "-", 2)).firstO());
    }
}
