package ru.yandex.chemodan.app.djfs.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author eoshch
 */
public final class ZipUtils {
    private static final int BUFFER_SIZE = 2048;

    public static byte[] compress(byte[] bytes, int level) {
        try {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream()) {
                Deflater deflater = new Deflater(level);
                try {
                    deflater.setInput(bytes);
                    deflater.finish();
                    byte[] buffer = new byte[BUFFER_SIZE];
                    while (!deflater.finished()) {
                        int size = deflater.deflate(buffer);
                        output.write(buffer, 0, size);
                    }
                } finally {
                    deflater.end();
                }
                return output.toByteArray();
            }
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static byte[] compressString(String value, int level) {
        return compress(CharsetUtils.encodeUtf8ToArray(value), level);
    }

    public static byte[] decompress(byte[] bytes) {
        try {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream()) {
                Inflater inflater = new Inflater();
                try {
                    inflater.setInput(bytes);
                    byte[] buffer = new byte[BUFFER_SIZE];
                    while (!inflater.finished()) {
                        int size = inflater.inflate(buffer);
                        output.write(buffer, 0, size);
                    }
                } finally {
                    inflater.end();
                }
                return output.toByteArray();
            }
        } catch (IOException | DataFormatException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static String decompressToString(byte[] bytes) {
        return CharsetUtils.decodeUtf8(decompress(bytes));
    }
}
