package ru.yandex.chemodan.app.djfs.core.versioning;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.chemodan.app.djfs.core.util.CeleryJobUtils;
import ru.yandex.chemodan.app.djfs.core.util.JsonUtils;
import ru.yandex.chemodan.queller.celery.job.CeleryJob;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.commune.bazinga.impl.TaskId;

/**
 * @author eoshch
 */
public class VersionManager {
    private static TaskId REMOVE_VERSIONS_TASK_ID =
            new TaskId("mpfs.core.versioning.job_handlers.handle_remove_versions");

    private final CeleryTaskManager celeryTaskManager;

    public VersionManager(CeleryTaskManager celeryTaskManager) {
        this.celeryTaskManager = celeryTaskManager;
    }

    public void removeVersions(DjfsResourceId resourceId) {
        JsonUtils.JsonObjectBuilder kwargsBuilder = JsonUtils.objectBuilder()
                .add("raw_resource_id", resourceId.toString());

        CeleryJob celeryJob = CeleryJobUtils.create(REMOVE_VERSIONS_TASK_ID, kwargsBuilder.toMap());
        celeryTaskManager.submit(celeryJob);
    }
}
