package ru.yandex.chemodan.app.djfs.core.web;

import ru.yandex.commune.a3.action.intercept.ActionDispatcherInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author eoshch
 */
public class ConnectionIdActionDispatcherInterceptor implements ActionDispatcherInterceptor {
    @Override
    public void beforeDispatch(WebRequest webRequest, ActionInvocationContext invocationContext) throws Exception {
        HttpServletRequestX reqx = webRequest.getHttpServletRequest();
        ConnectionIdHolder.set(reqx.getParameterO("connection_id").orElse(reqx.getParameterO("connectionId")));
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
