package ru.yandex.chemodan.app.djfs.core.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.SafeCloseable;
import ru.yandex.misc.ThreadLocalX;

/**
 * @author eoshch
 */
public class ConnectionIdHolder {
    private static final ThreadLocalX<String> connectionId = new ThreadLocalX<>();

    public static Option<String> getO() {
        return connectionId.getO();
    }

    public static SafeCloseable set(String connectionId) {
        ConnectionIdHolder.connectionId.set(connectionId);
        return ConnectionIdHolder::remove;
    }

    public static SafeCloseable set(Option<String> connectionIdO) {
        if (connectionIdO.isPresent()) {
            set(connectionIdO.get());
        } else {
            remove();
        }
        return ConnectionIdHolder::remove;
    }

    public static void remove() {
        connectionId.remove();
    }
}
