package ru.yandex.chemodan.app.djfs.core.web;

import java.io.Serializable;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.http.RequestNdcUtil;
import ru.yandex.chemodan.log.utils.TskvEscapeUtils;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.time.TimeUtils;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.web.servlet.HttpRequestUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author eoshch
 */
public class DjfsTskvLog4jRequestLog extends org.eclipse.jetty.util.component.AbstractLifeCycle implements RequestLog {
    private static final ru.yandex.misc.log.mlf.Logger logger =
            ru.yandex.misc.log.mlf.LoggerFactory.getLogger("ru.yandex.misc.web.servletContainer.jetty.tskv.access");

    public static Layout<? extends Serializable> layout(AppName applicationName) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-mpfs-access-log"
                + "\thost=" + HostnameUtils.localHostname()
                + "\tname=mpfs.access"
                + "\tappname=" + applicationName.appName()
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\t%m%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    @Override
    public void log(Request req, Response resp) {
        HttpServletRequestX reqx = HttpServletRequestX.wrap(req);
        String requestTime = TimeUtils.millisecondsToSecondsStringToNow(req.getTimeStamp());

        Option<String> uid = Option.ofNullable(req.getAttribute(UidActionDispatcherInterceptor.UID_ATTRIBUTE))
                .map(Object::toString);

        Option<MapF<String, String>> ndc = RequestNdcUtil.getNdcO(req);
        Option<String> rid = ndc.flatMapO(x -> x.getO("rid"));
        Option<String> ycrid = ndc.flatMapO(x -> x.getO("ycrid"));

        String headers = reqx.getHeaders().map(HttpRequestUtils::encodeSensitiveHeader)
                .map(x -> "\"" + x._1 + ": " + x._2 + "\"").mkString(" ");

        Tuple2List<String, String> fields = Tuple2List.fromPairs(
                "ycrid", ycrid.getOrElse("-"),
                "request_id", rid.getOrElse("-"),
                "pid", Thread.currentThread().getName(),
                "module", "-",
                "headers", headers,
                "method", req.getMethod(),
                "uid", uid.getOrElse("-"),
                "uri", req.getRequestURI() + (req.getQueryString() == null ? "" : "?" + req.getQueryString()),
                "proto", req.getProtocol(),
                "status", String.valueOf(resp.getStatus()),
                "request_time", requestTime);

        logger.info(fields.map((key, value) -> key + "=" +
                TskvEscapeUtils.escape(value, TskvEscapeUtils.DEFAULT_SYMBOL_ESCAPES_WITHOUT_QUOTES)).mkString("\t"));
    }
}
