package ru.yandex.chemodan.app.djfs.core.web;

import java.io.OutputStream;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.AbstractResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author eoshch
 */
public class JsonStringResultSerializer extends AbstractResultSerializer<JsonStringResult> {
    @Override
    protected void serializeSafely(JsonStringResult result, ActionInvocationContext context, OutputStream stream)
            throws Exception
    {
        stream.write(CharsetUtils.encodeUtf8ToArray(result.getResult()));
    }

    @Override
    protected boolean supports(Object result) {
        return result instanceof JsonStringResult;
    }

    @Override
    protected MediaType getContentType() {
        return MediaType.APPLICATION_JSON;
    }
}
