package ru.yandex.chemodan.app.djfs.core.web;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.lang.DefaultObject;

public class MasterSlavePolicyOverridesRegistry extends
        ZkRegistry<MasterSlavePolicyOverridesRegistry.PathDefinition, MasterSlavePolicyOverridesRegistry.MasterSlavePolicyOverride>
{
    public MasterSlavePolicyOverridesRegistry(ZkPath path)
    {
        super(path,
                new BenderMapper()
                        .createParserSerializer(MasterSlavePolicyOverridesRegistry.MasterSlavePolicyOverride.class)
                , MasterSlavePolicyOverride::getPathDefinition, PathDefinition::toString);
    }

    @Getter
    @AllArgsConstructor
    @BenderBindAllFields
    public static class PathDefinition extends DefaultObject {
        private String path;
        private Option<HttpMethod> method;

        public PathDefinition(String path) {
            this.path = path;
            this.method = Option.empty();
        }

        @Override
        public String toString() {
            return method.map(HttpMethod::name).getOrElse("-") + " " + path;
        }
    }

    @Data
    @BenderBindAllFields
    @AllArgsConstructor
    public static class MasterSlavePolicyOverride {
        private PathDefinition pathDefinition;
        private MasterSlavePolicy policy;
    }
}
