package ru.yandex.chemodan.app.djfs.core.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.intercept.ActionDispatcherInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author eoshch
 */
public class UidActionDispatcherInterceptor implements ActionDispatcherInterceptor {
    public static final String UID_ATTRIBUTE = "request-uid";

    @Override
    public void beforeDispatch(WebRequest webRequest, ActionInvocationContext invocationContext) throws Exception {
        HttpServletRequestX reqx = webRequest.getHttpServletRequest();

        Option<String> uid = reqx.getParameterO("uid");
        if (uid.isPresent()) {
            reqx.setAttribute(UID_ATTRIBUTE, uid.get());
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
