package ru.yandex.chemodan.app.djfs.worker;

import java.util.concurrent.TimeUnit;

import net.jodah.failsafe.RetryPolicy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.djfs.core.album.GeoAlbumGenerationProperties;
import ru.yandex.chemodan.app.djfs.core.album.GeoAlbumManager;
import ru.yandex.chemodan.app.djfs.core.album.worker.DjfsAlbumsTaskDao;
import ru.yandex.chemodan.app.djfs.core.album.worker.DjfsAlbumsTaskManager;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.filesystem.MongoDjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.PgDjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.index.BazingaManagerProperties;
import ru.yandex.chemodan.app.djfs.core.index.IndexerFetchExtractedDataTask;
import ru.yandex.chemodan.app.djfs.core.index.IndexerManager;
import ru.yandex.chemodan.app.djfs.core.index.IndexerSaveAestheticsTask;
import ru.yandex.chemodan.app.djfs.core.index.IndexerSaveCoordinatesTask;
import ru.yandex.chemodan.app.djfs.core.operations.MpfsOperationHandlerContext;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.tasks.DjfsTaskQueueName;
import ru.yandex.chemodan.app.djfs.core.tasks.DjfsTasksContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.user.UserDao;
import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationHandler;
import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationSender;
import ru.yandex.chemodan.app.djfs.worker.user.FindAllPermanentlyDeletedUsersCronTask;
import ru.yandex.chemodan.app.djfs.worker.user.FindRecentPermanentlyDeletedUsersCronTask;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryJavaWorkerContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTask;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.chemodan.queller.worker.CeleryTaskManagerContextConfiguration;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        CeleryTaskManagerContextConfiguration.class,
        CeleryJavaWorkerContextConfiguration.class,
        ChemodanBazingaWorkerContextConfiguration.class,
        DjfsTasksContextConfiguration.class,
})
public class DjfsWorkerContextConfiguration {
    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(CeleryOnetimeTask.BAZINGA_QUEUE_NAME));
    }

    @Bean
    public BazingaWorkerTaskQueues bazingaWorkerTaskQueues(
            @Value("${djfs.indexer-callback-tasks-queue.count}") int indexerCallbackTasksQueueThreadCount,
            @Value("${djfs.indexer-callback-tasks-queue.queue}") int indexerCallbackTasksQueueCount,
            @Value("${djfs.filesystem-post-process-tasks-queue.count}") int filesystemPostProcessTasksQueueThreadCount,
            @Value("${djfs.filesystem-post-process-tasks-queue.queue}") int filesystemPostProcessTasksQueueCount)
    {
        TaskQueue indexerCallbackTasksQueue = new TaskQueue(DjfsTaskQueueName.INDEXER_CALLBACK_TASKS,
                        indexerCallbackTasksQueueThreadCount, indexerCallbackTasksQueueCount);
        TaskQueue filesystemPostProcessTasksQueue = new TaskQueue(DjfsTaskQueueName.FILESYSTEM_POST_PROCESS_TASKS,
                        filesystemPostProcessTasksQueueThreadCount, filesystemPostProcessTasksQueueCount);

        return new BazingaWorkerTaskQueues(TaskQueueName.CRON, TaskQueueName.REGULAR, TaskQueueName.CPU_INTENSIVE,
                Cf.list(
                        new TaskQueue(CeleryOnetimeTask.BAZINGA_QUEUE_NAME, 1, 0),
                        indexerCallbackTasksQueue,
                        filesystemPostProcessTasksQueue
                )
        );
    }

    @Bean
    public IndexerSaveAestheticsTask indexerSaveAestheticsTask(IndexerManager indexerManager,
            DjfsAlbumsTaskManager djfsAlbumsTaskManager, BazingaTaskManager bazingaTaskManager, BazingaManagerProperties bazingaTaskManagerProperties,
            GeoAlbumGenerationProperties geoAlbumGenerationProperties, GeoAlbumManager geoAlbumManager)
    {
        return new IndexerSaveAestheticsTask(indexerManager, djfsAlbumsTaskManager, bazingaTaskManager, bazingaTaskManagerProperties,
                geoAlbumGenerationProperties, geoAlbumManager);
    }

    @Bean
    public IndexerSaveCoordinatesTask indexerSaveCoordinatesTask(IndexerManager indexerManager,
            DjfsAlbumsTaskManager djfsAlbumsTaskManager, BazingaTaskManager bazingaTaskManager, BazingaManagerProperties bazingaTaskManagerProperties,
            GeoAlbumGenerationProperties geoAlbumGenerationProperties, GeoAlbumManager geoAlbumManager)
    {
        return new IndexerSaveCoordinatesTask(indexerManager, djfsAlbumsTaskManager, bazingaTaskManager, bazingaTaskManagerProperties,
                geoAlbumGenerationProperties, geoAlbumManager);
    }

    @Bean
    public IndexerFetchExtractedDataTask indexerFetchExtractedDataTask(UserDao userDao, IndexerManager indexerManager) {
        return new IndexerFetchExtractedDataTask(userDao, indexerManager);
    }

    @Bean
    public FindRecentPermanentlyDeletedUsersCronTask findRecentPermanentlyDeletedUsersCronTask(
            @Value("${yql.datasource.url}") String yqlUrl, @Value("${djfs.yql.token}") String yqlToken,
            UserPermanentDeleteOperationSender userPermanentDeleteOperationSender,
            UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler)
    {
        return new FindRecentPermanentlyDeletedUsersCronTask(yqlUrl, yqlToken, userPermanentDeleteOperationSender,
                userPermanentDeleteOperationHandler);
    }

    @Bean
    public FindAllPermanentlyDeletedUsersCronTask findAllPermanentlyDeletedUsersCronTask(
            @Value("${yql.datasource.url}") String yqlUrl, @Value("${djfs.yql.token}") String yqlToken,
            UserPermanentDeleteOperationSender userPermanentDeleteOperationSender,
            UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler)
    {
        return new FindAllPermanentlyDeletedUsersCronTask(yqlUrl, yqlToken, userPermanentDeleteOperationSender,
                userPermanentDeleteOperationHandler);
    }

    @Bean
    public ExportStidsToYtOperation.Handler exportStidsToYtOperationHandler(@Value("${yql.datasource.url}") String yqlUrl,
            @Value("${djfs.yql.token}") String yqlToken, MpfsOperationHandlerContext mpfsOperationHandlerContext,
            MongoDjfsResourceDao mongoDjfsResourceDao, PgDjfsResourceDao pgDjfsResourceDao)
            throws ClassNotFoundException
    {
        Class.forName("ru.yandex.yql.YqlDriver");
        return new ExportStidsToYtOperation.Handler(yqlUrl, yqlToken, mpfsOperationHandlerContext, mongoDjfsResourceDao,
                pgDjfsResourceDao);
    }

    @Bean
    public ExportStidsToYtOperation.Sender exportStidsToYtOperationSender(CeleryTaskManager celeryTaskManager,
            OperationDao operationDao)
    {
        return new ExportStidsToYtOperation.Sender(celeryTaskManager, operationDao);
    }

    @Bean
    public YtHelper ytHelper(@Value("${yt.url}") String ytUrl, @Value("${djfs.yql.token}") String ytToken) {
        Yt yt = YtUtils.http(ytUrl, ytToken);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(3).withDelay(10, TimeUnit.SECONDS);
        return new YtHelper(yt, retryPolicy);
    }

    @Bean
    public ExportOctober2018StorageFailureStidCandidatesToYtOperation.Handler exportOctober2018StorageFailureStidCandidatesToYtOperationHandler(
            YtHelper ytHelper, MpfsOperationHandlerContext mpfsOperationHandlerContext, MongoDjfsResourceDao mongoDjfsResourceDao,
            PgDjfsResourceDao pgDjfsResourceDao)
    {
        return new ExportOctober2018StorageFailureStidCandidatesToYtOperation.Handler(
                ytHelper, mpfsOperationHandlerContext, mongoDjfsResourceDao, pgDjfsResourceDao);
    }

    @Bean
    public ExportOctober2018StorageFailureStidCandidatesToYtOperation.Sender exportOctober2018StorageFailureStidCandidatesToYtOperationSender(
            CeleryTaskManager celeryTaskManager, OperationDao operationDao)
    {
        return new ExportOctober2018StorageFailureStidCandidatesToYtOperation.Sender(celeryTaskManager, operationDao);
    }

    @Bean
    public DjfsAlbumsTaskManager djfsAlbumsTaskManager(BazingaTaskManager bazingaTaskManager, DjfsAlbumsTaskDao djfsAlbumsTaskDao) {
        return new DjfsAlbumsTaskManager(bazingaTaskManager, djfsAlbumsTaskDao);
    }

    @Bean
    public DjfsAlbumsTaskDao djfsAlbumsTaskDao(PgShardedDaoContext context) {
        return new DjfsAlbumsTaskDao(context);
    }
}
