package ru.yandex.chemodan.app.djfs.worker.user;

import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationHandler;
import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationSender;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleNever;

/**
 * @author eoshch
 */
public class FindAllPermanentlyDeletedUsersCronTask extends FindPermanentlyDeletedUsersCronTaskBase {
    public FindAllPermanentlyDeletedUsersCronTask(String yqlUrl, String yqlToken,
            UserPermanentDeleteOperationSender userPermanentDeleteOperationSender,
            UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler)
    {
        super(yqlUrl, yqlToken, userPermanentDeleteOperationSender, userPermanentDeleteOperationHandler);
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleNever();
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(5);
    }

    @Override
    public void execute() throws Exception {
        // todo: optimize: query yql in parallel
        // LocalDate current = new LocalDate(2018, 6, 3);
        LocalDate current = new LocalDate(2018, 10, 1);
        LocalDate end = LocalDate.now().minusDays(2);

        while (!current.equals(end)) {
            findPermanentlyDeletedUsers(current);
            current = current.plusDays(1);
        }
    }
}
