package ru.yandex.chemodan.app.djfs.worker.user;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.chemodan.app.djfs.core.tasks.DjfsCronTask;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationHandler;
import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationSender;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author eoshch
 */
public abstract class FindPermanentlyDeletedUsersCronTaskBase extends DjfsCronTask {
    private static final Logger logger = LoggerFactory.getLogger(FindRecentPermanentlyDeletedUsersCronTask.class);

    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy-MM-dd");

    private static final String YQL = ""
            + "select uid\n"
            + "from `logs/passport-log/1d/{date}`\n"
            + "where mode == 'account_delete'\n"
            + "and action == 'deleted'\n"
            + ";";

    private final String yqlUrl;
    private final String yqlToken;
    private final UserPermanentDeleteOperationSender userPermanentDeleteOperationSender;
    private final UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler;

    public FindPermanentlyDeletedUsersCronTaskBase(String yqlUrl, String yqlToken,
            UserPermanentDeleteOperationSender userPermanentDeleteOperationSender,
            UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler)
    {
        this.yqlUrl = yqlUrl;
        this.yqlToken = yqlToken;
        this.userPermanentDeleteOperationSender = userPermanentDeleteOperationSender;
        this.userPermanentDeleteOperationHandler = userPermanentDeleteOperationHandler;
    }

    protected void findPermanentlyDeletedUsers(LocalDate date) throws Exception {
        logger.info("processing " + date.toString());

        String yql = YQL.replace("{date}", date.toString(formatter));
        Class.forName("ru.yandex.yql.YqlDriver");

        try (Connection connection = DriverManager.getConnection(yqlUrl, "unused", yqlToken);
             PreparedStatement statement = connection.prepareStatement(yql))
        {
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                DjfsUid uid = DjfsUid.cons(resultSet.getString("uid"));
                if (userPermanentDeleteOperationHandler.isHandlingNeeded(uid)) {
                    userPermanentDeleteOperationSender.send(uid);
                }
            }
        }

        logger.info("finished processing " + date.toString());
    }
}
