package ru.yandex.chemodan.app.djfs.worker.user;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;

import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationHandler;
import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationSender;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.devtools.test.annotations.YaIgnore;

/**
 * @author eoshch
 */
@YaIgnore
public class FindPermanentlyDeletedUsersCronTaskTest /*extends DjfsTestBase */ {

    @Autowired
    UserPermanentDeleteOperationSender userPermanentDeleteOperationSender;

    @Autowired
    UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler;

    @Test
    @Ignore
    public void execute() throws Exception {
        String yqlUrl = "jdbc:yql://yql.yandex.net:443/hahn?syntaxVersion=1";
        String yqlToken = "PASTE_YOURS";
        FindRecentPermanentlyDeletedUsersCronTask task = new FindRecentPermanentlyDeletedUsersCronTask(yqlUrl, yqlToken,
                userPermanentDeleteOperationSender, userPermanentDeleteOperationHandler);
        task.execute(Mockito.mock(ExecutionContext.class));
    }

    @Test
    @Ignore
    public void yqlExceptionTest() throws Exception {
        String yqlUrl = "jdbc:yql://yql.yandex.net:443/hahn?syntaxVersion=1";
        String yqlToken = "PASTE_YOURS";

        String yql = "select 1;";
        Class.forName("ru.yandex.yql.YqlDriver");

//        for (int i = 0; i < 1000; i++) {
//            try (Connection connection = DriverManager.getConnection(yqlUrl, "unused", yqlToken);
//                 PreparedStatement statement = connection.prepareStatement(yql))
//            {
//                statement.execute();
//                System.out.println(i);
//            }
//        }
//
//        try (Connection connection = DriverManager.getConnection(yqlUrl, "unused", yqlToken)) {
//            for (int i = 0; i < 1000; i++) {
//                try (PreparedStatement statement = connection.prepareStatement(yql)) {
//                    statement.execute();
//                    System.out.println(i);
//                }
//            }
//        }

        try (Connection connection = DriverManager.getConnection(yqlUrl, "unused", yqlToken);
             PreparedStatement statement = connection.prepareStatement(yql))
        {
            for (int i = 0; i < 1000; i++) {
                statement.execute();
                System.out.println(i);
            }
        }
    }
}
