package ru.yandex.chemodan.app.djfs.worker.user;

import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationHandler;
import ru.yandex.chemodan.app.djfs.core.user.UserPermanentDeleteOperationSender;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

/**
 * @author eoshch
 */
public class FindRecentPermanentlyDeletedUsersCronTask extends FindPermanentlyDeletedUsersCronTaskBase {
    public FindRecentPermanentlyDeletedUsersCronTask(String yqlUrl, String yqlToken,
            UserPermanentDeleteOperationSender userPermanentDeleteOperationSender,
            UserPermanentDeleteOperationHandler userPermanentDeleteOperationHandler)
    {
        super(yqlUrl, yqlToken, userPermanentDeleteOperationSender, userPermanentDeleteOperationHandler);
    }

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(Duration.standardHours(1));
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(30);
    }

    @Override
    public void execute() throws Exception {
        findPermanentlyDeletedUsers(LocalDate.now().minusDays(3));
        findPermanentlyDeletedUsers(LocalDate.now().minusDays(2));
    }
}
