#!/bin/bash -e

ec() {
    echo "$@"
    "$@"
}

START_DIR=$(dirname pwd)

ec cd $(dirname $0)

ec eval $(docker-machine env)
ec rm -rf lib
ec mkdir lib
ec ../../../compile.sh
ec cp ../../../common/target/jars/yandex-chemodan.jar ./lib/app.jar
ec cp ../../../common/lib/runtime/*.jar ./lib/

VERSION=$(svn info ../../.. | fgrep "Last Changed Rev:" | sed 's/Last Changed Rev: \([0-9]*\)/\1/')

ec docker build -t registry.yandex.net/axis/axis-factapi:$VERSION .
ec docker push registry.yandex.net/axis/axis-factapi:$VERSION

rm -rf lib

ec cd $START_DIR
