package ru.yandex.chemodan.app.docviewer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2List;

public interface MimeTypes {

    String MIME_PDF = "application/pdf";
    String MIME_ADOBE_PHOTOSHOP = "image/vnd.adobe.photoshop";
    String MIME_ADOBE_POSTSCRIPT = "application/postscript";
    String MIME_ILLUSTRATOR = "application/illustrator";

    String MIME_ARCHIVE_ZIP = "application/zip";

    String MIME_COREL_DRAW = "application/cdr";

    String MIME_CSV = "text/csv";

    String MIME_ICO = "image/x-icon";

    String MIME_HTML = "text/html";

    String MIME_IMAGE_JPEG = "image/jpeg";
    String MIME_IMAGE_PNG = "image/png";
    String MIME_IMAGE_SVG = "image/svg+xml";
    String MIME_IMAGE_TIFF = "image/tiff";
    String MIME_IMAGE_GIF = "image/gif";
    String MIME_IMAGE_X_NIKON_NEF = "image/x-nikon-nef";

    String MIME_MICROSOFT_BMP = "image/x-ms-bmp";
    String MIME_MICROSOFT_EMF = "image/x-emf";
    String MIME_MICROSOFT_EXCEL = "application/vnd.ms-excel";
    String MIME_MICROSOFT_POWERPOINT = "application/vnd.ms-powerpoint";
    String MIME_MICROSOFT_SPREADSHEETML = "x-application/vnd.ms-spreadsheetml";
    String MIME_MICROSOFT_WMF = "image/x-wmf";
    String MIME_MICROSOFT_WORD = "application/msword";
    String MIME_MICROSOFT_WORDML = "x-application/vnd.ms-wordml";

    String MIME_MICROSOFT_OOXML_EXCEL = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    String MIME_MICROSOFT_OOXML_EXCEL_TEMPLATE = "application/vnd.openxmlformats-officedocument.spreadsheetml.template";
    String MIME_MICROSOFT_OOXML_POWERPOINT = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    String MIME_MICROSOFT_OOXML_POWERPOINT_TEMPLATE = "application/vnd.openxmlformats-officedocument.presentationml.template";
    String MIME_MICROSOFT_OOXML_WORD = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    String MIME_MICROSOFT_OOXML_WORD_TEMPLATE = "application/vnd.openxmlformats-officedocument.wordprocessingml.template";

    String MIME_OPENDOCUMENT_PRESENTATION = "application/vnd.oasis.opendocument.presentation";
    String MIME_OPENDOCUMENT_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
    String MIME_OPENDOCUMENT_TEXT = "application/vnd.oasis.opendocument.text";

    String MIME_RTF = "application/rtf";

    String MIME_TEXT_PLAIN = "text/plain";
    String MIME_PGP = "application/pgp";

    String MIME_UNKNOWN = "application/octet-stream";

    String MIME_XML = "text/xml";

    String MIME_FB2 = "application/x-fictionbook+xml";
    String MIME_EPUB = "application/epub+zip";
    String MIME_MOBI = "application/x-mobipocket-ebook";
    String MIME_DJVU = "application/djvu";

    String APPLICATION_X_CORELDRAW_RIFF_COMPRESSED = "application/x-coreldraw-riff-compressed";
    String ARCHIVE_X_SEVENZIP_SUPPORTED = "archive/x-sevenzip-supported";
    String IMAGE_X_IMAGEMAGICK_SUPPORTED = "image/x-imagemagick-supported";

    SetF<String> SYNONYMS_DJVU = Cf.set(MIME_DJVU, "image/vnd.djvu", "image/x-djvu");

    SetF<String> SYNONYMS_ADOBE_ACROBAT = Cf.set(MIME_PDF,
            "application/x-pdf", "application/acrobat", "applications/vnd.pdf", "text/pdf",
            "text/x-pdf");

    SetF<String> SYNONYMS_ADOBE_PHOTOSHOP = Cf.set("image/photoshop",
            "image/x-photoshop", "image/psd", "application/photoshop", "application/psd",
            "zz-application/zz-winassoc-psd");

    SetF<String> SYNONYMS_ARCHIVE_ZIP = Cf.set(MIME_ARCHIVE_ZIP,
            "application/x-zip", "application/x-zip-compressed", "multipart/x-zip");

    SetF<String> SYNONYMS_CDR = Cf.set(
            MIME_COREL_DRAW, "application/x-cdr",
            "application/coreldraw", "application/x-coreldraw", "application/vnd.corel-draw",
            "image/cdr", "image/x-cdr", "image/x-coreldraw",
            "zz-application/zz-winassoc-cdr");

    SetF<String> SYNONYMS_CSV = Cf.set(MIME_CSV,
            "text/comma-separated-values");

    SetF<String> SYNONYMS_ICO = Cf.set(MIME_ICO, "image/vnd.microsoft.icon",
            "image/ico", "application/ico", "application/x-ico"
            //, "application/x-win-bitmap", "image/x-win-bitmap"
            );

    SetF<String> SYNONYMS_MICROSOFT_BMP = Cf.set(MIME_MICROSOFT_BMP,
            "image/x-bmp");

    SetF<String> SYNONYMS_MICROSOFT_EXCEL = Cf.set(
            MIME_MICROSOFT_EXCEL, "application/msexcel", "application/x-msexcel",
            "application/x-ms-excel", "application/x-excel",
            "application/x-dos_ms_excel", "application/xls");

    SetF<String> SYNONYMS_MICROSOFT_POWERPOINT = Cf.set(
            MIME_MICROSOFT_POWERPOINT, "application/mspowerpoint",
            "application/ms-powerpoint", "application/mspowerpnt",
            "application/vnd-mspowerpoint", "application/powerpoint",
            "application/x-powerpoint");

    SetF<String> SYNONYMS_MICROSOFT_WORD = Cf.set(
            MIME_MICROSOFT_WORD, "application/doc", "application/vnd.msword",
            "application/vnd.ms-word", "application/winword", "application/word",
            "application/x-msw6", "application/x-msword");

    SetF<String> SYNONYMS_RTF = Cf.set(MIME_RTF, "text/rtf");

    SetF<String> SYNONYMS_TEXT = Cf.set(MIME_TEXT_PLAIN,
            "application/x-shellscript");



    SetF<String> MIME_NORMALIZED_ARCHIVES = Cf.set(
            MimeTypes.ARCHIVE_X_SEVENZIP_SUPPORTED,
            "application/x-7z-compressed",
            "application/x-debian-package",
            "application/x-bzip",
            "application/x-bzip2",
            "application/x-gzip", "application/gzip", "application/x-gunzip", "application/gzipped",
                    "application/gzip-compressed", "gzip/document",
            "application/x-iso9660-image",
            "application/x-tar",
            "application/x-rar", "application/x-rar-compressed",
            "application/x-rpm",
            MimeTypes.MIME_ARCHIVE_ZIP, "application/x-zip", "application/x-zip-compressed"
    );

    // TODO move both maps to ImageFormat class,
    // which includes adding content/type and 'jpeg' alias for JPEG there
    MapF<String, String> IMAGE_MIME_2_EXT = Cf.<String, String>map()
            .plus1(MIME_IMAGE_JPEG, "jpg")
            .plus1(MIME_IMAGE_PNG, "png")
            .plus1(MIME_IMAGE_GIF, "gif")
            ;
    MapF<String, String> IMAGE_EXT_2_MIME = IMAGE_MIME_2_EXT
            .entries().invert().toMap()
            .plus1("jpeg", MIME_IMAGE_JPEG)
            ;

    SetF<String> MIME_UNKNOWNS = Cf.set(MIME_UNKNOWN, "application/binary");


    // this is copy/paste from uploader's MimeTypeDetector with some additions
    // to better determine mime types purely by file extension for archives
    // TODO unify mime detectors (DOCVIEWER-714)
    MapF<String, String> overrideExtensionMimeTypes = Tuple2List.<String, String>fromPairs(
            ".3g2", "video/3gpp",
            ".7z" , "application/x-7z-compressed",
            ".aac", "audio/aac",
            ".cdr", MIME_COREL_DRAW,
            ".chm", "application/x-chm",
            ".com", "application/com",
            ".cr2", "image/x-canon-cr2",
            ".csv", MIME_CSV,
            ".db", MIME_UNKNOWN, // Thumbs.db
            ".dmg", "application/x-apple-diskimage",
            ".exe", "application/x-msdownload",
            ".fla", "application/x-fla", // ssytnik: clashes with audio/flac
            ".flv", "video/x-flv",
            ".ics", "text/calendar",
            ".jnlp","application/x-java-jnlp-file",
            ".key", "application/x-iwork-keynote-sffkey",
            ".m4v", "video/x-m4v",
            ".mkv", "video/x-matroska",
            ".mp3", "audio/mpeg", // ssytnik: mimeutil gave video/x-mpeg for some reason
            ".mp4", "video/mp4",
            ".msi", "application/x-msi",
            ".nef", MIME_IMAGE_X_NIKON_NEF,
            ".numbers", "application/x-iwork-numbers",
            ".ogg", "application/ogg",
            ".pages", "application/x-iwork-pages-sffpages",
            ".php", "text/php", // ssytnik: wrong?
            ".pls", "audio/x-scpls",
            ".psd", MIME_ADOBE_PHOTOSHOP,
            ".rar", "application/x-rar",
            ".rmvb","application/vnd.rn-realmedia-vbr",
            ".rpm", "application/x-rpm", // ssytnik: clashes with audio/x-pn-realaudio-plugin
            ".svg", MIME_IMAGE_SVG,
            ".tbz", "application/x-bzip",
            ".tbz2","application/x-bzip2",
            ".tga", "image/x-tga",
            ".tgz", "application/x-gzip",
            ".ttf", "font/ttf",
            ".wmv", "video/x-ms-wmv", // ssytnik: overrides mimeutil's audio/x-ms-wmv
            ".xar", ARCHIVE_X_SEVENZIP_SUPPORTED,

            // office mappings
            // http://www.opendocman.com/forum/viewtopic.php?f=4&t=311
            // http://stackoverflow.com/questions/4212861/what-is-a-correct-mime-type-for-docx-pptx-etc
            ".doc", MIME_MICROSOFT_WORD,
            ".dot", MIME_MICROSOFT_WORD,
            ".docx", MIME_MICROSOFT_OOXML_WORD,
            ".dotx", MIME_MICROSOFT_OOXML_WORD_TEMPLATE,
            ".docm", "application/vnd.ms-word.document.macroEnabled.12",
            ".dotm", "application/vnd.ms-word.template.macroEnabled.12",
            ".xls", MIME_MICROSOFT_EXCEL,
            ".xlt", MIME_MICROSOFT_EXCEL,
            ".xla", MIME_MICROSOFT_EXCEL,
            ".xlsx", MIME_MICROSOFT_OOXML_EXCEL,
            ".xltx", MIME_MICROSOFT_OOXML_EXCEL_TEMPLATE,
            ".xlsm", "application/vnd.ms-excel.sheet.macroEnabled.12",
            ".xltm", "application/vnd.ms-excel.template.macroEnabled.12",
            ".xlam", "application/vnd.ms-excel.addin.macroEnabled.12",
            ".xlsb", "application/vnd.ms-excel.sheet.binary.macroEnabled.12",
            ".ppt", MIME_MICROSOFT_POWERPOINT,
            ".pot", MIME_MICROSOFT_POWERPOINT,
            ".pps", MIME_MICROSOFT_POWERPOINT,
            ".ppa", MIME_MICROSOFT_POWERPOINT,
            ".pptx", MIME_MICROSOFT_OOXML_POWERPOINT,
            ".potx", MIME_MICROSOFT_OOXML_POWERPOINT_TEMPLATE,
            ".ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
            ".ppam", "application/vnd.ms-powerpoint.addin.macroEnabled.12",
            ".pptm", "application/vnd.ms-powerpoint.presentation.macroEnabled.12",
            ".potm", "application/vnd.ms-powerpoint.template.macroEnabled.12",
            ".ppsm", "application/vnd.ms-powerpoint.slideshow.macroEnabled.12",

            // openoffice mappings
            ".odt", MIME_OPENDOCUMENT_TEXT,
            ".odp", MIME_OPENDOCUMENT_PRESENTATION,
            ".ods", MIME_OPENDOCUMENT_SPREADSHEET,
            ".odg", "application/vnd.oasis.opendocument.graphics",

            // DV additions
            ".txt", MIME_TEXT_PLAIN,
            ".text", MIME_TEXT_PLAIN,
            ".log", MIME_TEXT_PLAIN,
            ".java", MIME_TEXT_PLAIN,
            ".nef", MIME_IMAGE_X_NIKON_NEF,
            ".pdf", MIME_PDF,
            ".rtf", MIME_RTF,

            ".gz", "application/x-gzip",
            ".bz2", "application/x-bzip2",
            ".tar", "application/x-tar",
            ".zip", MIME_ARCHIVE_ZIP,

            ".jpg", MIME_IMAGE_JPEG,
            ".jpeg", MIME_IMAGE_JPEG,
            ".gif", MIME_IMAGE_GIF,
            ".bmp", "image/bmp",
            ".png", MIME_IMAGE_PNG,

            ".fb2", MIME_FB2,
            ".epub", MIME_EPUB,
            ".mobi", MIME_MOBI,
            ".djvu", MIME_DJVU,
            ".xml", MIME_XML

            ).toMap();
}
