package ru.yandex.chemodan.app.docviewer;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */

@SuppressWarnings("unchecked")
public abstract class MimeTypesHelper {
    public static SetF<String> getAllMimeTypes() {
        SetF<String> allMimeTypes = Cf.hashSet();
        ClassX<MimeTypes> clazz = ClassX.wrap(MimeTypes.class);
        // Only public because MimeTypes is interface
        ListF<FieldX> fields = clazz.getFields();
        for (FieldX field : fields) {
            Check.isTrue(field.isStatic());
            Class<?> fieldClazz = field.getType().getClazz();
            if (String.class.isAssignableFrom(fieldClazz)) {
                allMimeTypes.add((String) field.getStatic());
            } else if (Collection.class.isAssignableFrom(fieldClazz)) {
                Collection<?> collection = (Collection<?>) field.getStatic();
                Class<?> collectionParameterClazz =
                        (Class<?>) (((ParameterizedType) field.getGenericType().getType())
                                .getActualTypeArguments()[0]);
                if (String.class.isAssignableFrom(collectionParameterClazz)) {
                    allMimeTypes.addAll((Collection<? extends String>) collection);
                }
            }
        }
        return allMimeTypes;
    }
}
