package ru.yandex.chemodan.app.docviewer.adapters.freehep;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;

import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFImageLoader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.graphicsio.emf.gdi.BlendFunction;

public class AdditionalImageLoader {

    public static BufferedImage readImage(BitmapInfoHeader bmi, int width, int height,
            EMFInputStream emf, int len, BlendFunction blendFunction) throws IOException
    {
        if ((bmi.getBitCount() == 24) && (bmi.getCompression() == EMFConstants.BI_RGB)) {

            // black magic
            int perRowSkip = 0;
            if ((len - width * height * 3) % height == 0) {
                perRowSkip = (len - width * height * 3) / height;
            }

            int[] data = emf.readUnsignedByte(len);

            BufferedImage result = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

            int off = 0;
            for (int y = height - 1; y > -1; y--) {
                for (int x = 0; x < width; x++) {
                    int b = data[off++];
                    int g = data[off++];
                    int r = data[off++];

                    result.setRGB(x, y, new Color(r / 255f, g / 255f, b / 255f).getRGB());
                }

                // black magic
                for (int i = 0; i < perRowSkip; i++) {
                    off++;
                }
            }

            // ImageIoUtils.write(result, "jpeg", new File2("test.jpg"));

            return result;
        }

        return EMFImageLoader.readImage(bmi, width, height, emf, len, blendFunction);
    }

}
