package ru.yandex.chemodan.app.docviewer.adapters.freehep;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;

import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.BitmapInfo;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.graphicsio.emf.gdi.BlendFunction;
import org.freehep.graphicsio.emf.gdi.StretchDIBits;

import ru.yandex.misc.ExceptionUtils;

public class ExtendedStretchDiBits extends StretchDIBits {

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle bounds = emf.readRECTL(); // 16
        int x = emf.readLONG(); // 20
        int y = emf.readLONG(); // 24
        int xSrc = emf.readLONG(); // 28
        int ySrc = emf.readLONG(); // 32
        int width = emf.readLONG(); // 36
        int height = emf.readLONG(); // 40
        // ignored
        emf.readDWORD(); // 44
        emf.readDWORD(); // 48
        emf.readDWORD(); // 52
        emf.readDWORD(); // 56

        int usage = emf.readDWORD(); // 60
        int dwROP = emf.readDWORD(); // 64
        int widthSrc = emf.readLONG(); // 68
        int heightSrc = emf.readLONG(); // 72

        BitmapInfo bmi = new BitmapInfo(emf);

        BufferedImage image = AdditionalImageLoader.readImage(bmi.getHeader(), width, height, emf,
                len - 72 - BitmapInfoHeader.size, new BlendFunction(AC_SRC_OVER, 0, 0xFF, AC_SRC_ALPHA));

        StretchDIBits tag = new StretchDIBits();

        try {
            Field fBounds = StretchDIBits.class.getDeclaredField("bounds");
            fBounds.setAccessible(true);
            fBounds.set(tag, bounds);

            Field fX = StretchDIBits.class.getDeclaredField("x");
            fX.setAccessible(true);
            fX.set(tag, x);

            Field fY = StretchDIBits.class.getDeclaredField("y");
            fY.setAccessible(true);
            fY.set(tag, y);

            Field fXSrc = StretchDIBits.class.getDeclaredField("xSrc");
            fXSrc.setAccessible(true);
            fXSrc.set(tag, xSrc);

            Field fYSrc = StretchDIBits.class.getDeclaredField("ySrc");
            fYSrc.setAccessible(true);
            fYSrc.set(tag, ySrc);

            Field fWidth = StretchDIBits.class.getDeclaredField("width");
            fWidth.setAccessible(true);
            fWidth.set(tag, width);

            Field fHeight = StretchDIBits.class.getDeclaredField("height");
            fHeight.setAccessible(true);
            fHeight.set(tag, height);

            Field fUsage = StretchDIBits.class.getDeclaredField("usage");
            fUsage.setAccessible(true);
            fUsage.set(tag, usage);

            Field fDwROP = StretchDIBits.class.getDeclaredField("dwROP");
            fDwROP.setAccessible(true);
            fDwROP.set(tag, dwROP);

            Field fWidthSrc = StretchDIBits.class.getDeclaredField("widthSrc");
            fWidthSrc.setAccessible(true);
            fWidthSrc.set(tag, widthSrc);

            Field fHeightSrc = StretchDIBits.class.getDeclaredField("heightSrc");
            fHeightSrc.setAccessible(true);
            fHeightSrc.set(tag, heightSrc);

            Field fBmi = StretchDIBits.class.getDeclaredField("bmi");
            fBmi.setAccessible(true);
            fBmi.set(tag, bmi);

            Field fImage = StretchDIBits.class.getDeclaredField("image");
            fImage.setAccessible(true);
            fImage.set(tag, image);

        } catch (Exception exc) {
            throw ExceptionUtils.translate(exc);
        }

        return tag;
    }

}
