package ru.yandex.chemodan.app.docviewer.adapters.imagemagick;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.io.file.File2;

/**
 * Annotates images
 * @author ssytnik
 * @author akirakozov
 */
public class ImageAnnotator {

    private final String convert;

    public ImageAnnotator(String convertCmd) {
        this.convert = convertCmd;
    }

    static String offsetParam(int offset) {
        return offset >= 0 ? "+" + offset : String.valueOf(offset);
    }

    private static String offsetParams(int xOffset, int yOffset) {
        return offsetParam(xOffset) + offsetParam(yOffset);
    }

    ListF<String> createAnnotateScripts(
            File2 sourceFile, File2 targetFile, Tuple2List<String, AnnotateImageOptions> annotations)
    {
        ListF<String> cmd = Cf.arrayList();

        cmd.add(convert);
        for (Tuple2<String, AnnotateImageOptions> annotation : annotations) {
            String text = annotation.get1();
            AnnotateImageOptions options = annotation.get2();

            cmd.addAll("-fill", options.getFontColor());
            cmd.addAll("-font", options.getFont());
            cmd.addAll("-pointsize", String.valueOf(options.getPointSize()));
            cmd.addAll("-gravity", "North");
            cmd.addAll("-annotate", offsetParams(options.getXOffset(), + options.getYOffset()),
                    text.replace("\n", "\\n"));
        }
        cmd.add(sourceFile.getAbsolutePath());
        cmd.add(targetFile.getAbsolutePath());
        return cmd;
    }

    // in this scenario, client is responsible for deleting temp file specified in the result
    public File2 convert(
            File2 sourceFile, Tuple2List<String, AnnotateImageOptions> annotations, ImageFormat resultFormat)
    {
        File2 targetFile = FileUtils.createEmptyTempFile(
                "txt2img-output", "." + resultFormat.getExtension());
        try {
            ListF<String> cmd = createAnnotateScripts(sourceFile, targetFile, annotations);

            ExecUtils.executeCommand(cmd);

            return targetFile;
        } catch (RuntimeException e) {
            targetFile.deleteRecursiveQuietly();
            throw e;
        }
    }

}
