package ru.yandex.chemodan.app.docviewer.adapters.imagemagick;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;

/**
 * Target convert info
 *
 * @author ssytnik
 */
@Data
public class ImageMagickConvertInfo {
    private final Option<File2> tempFileO;
    private final ImageFormat format;
    private final Dimension size;

    public ImageMagickConvertInfo withoutTempFile() {
        return new ImageMagickConvertInfo(Option.empty(), format, size);
    }

}
