package ru.yandex.chemodan.app.docviewer.adapters.imagemagick;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author ssytnik
 * @see TextSplitOptions
 */
public class TextSplitter {

    public static ListF<String> splitLongLines(String sourceLine, TextSplitOptions options) {
        ListF<String> text = Cf.list(sourceLine.split("\n"));

        ListF<String> res = Cf.arrayList();
        for (String line : text) {
            if (line.length() <= options.getMaxSplitPieceLength()) {
                res.add(line);
            } else {
                int pieces = 1;
                StringBuilder piece = new StringBuilder();
                for (String word : StringUtils.split(line)) {
                    if (startNewLineCondition(options, pieces, piece, word)) {
                        res.add(piece.toString());
                        piece = new StringBuilder();
                        pieces++;
                    }
                    if (piece.length() > 0) {
                        piece.append(' ');
                    }
                    piece.append(word);
                }
                res.add(piece.toString());
            }
        }
        return res.subList(0, Math.min(res.size(), options.getMaxLinesCount()));
    }

    private static boolean startNewLineCondition(TextSplitOptions options,
            int pieces, StringBuilder piece, String word)
    {
        int currentLineLenght = piece.length() + word.length();
        return piece.length() > 0 && currentLineLenght + 1 > options.getMaxSplitPieceLength();
    }

}
