package ru.yandex.chemodan.app.docviewer.adapters.openoffice;

import lombok.RequiredArgsConstructor;
import lombok.ToString;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.porto.PortoClient;
import ru.yandex.misc.dataSize.DataSize;

@RequiredArgsConstructor
@ToString
public class OfficeContainerHandle implements OfficeHandle {

    @ToString.Exclude
    private final PortoClient client;
    private final String container;

    @Override
    public boolean isAlive() {
        return client.get(container, "state").isMatch(Cf.list("running", "starting")::containsTs);
    }

    @Override
    public Option<Integer> getExitCode() {
        return client.get(container, "exit_code").map(Integer::parseInt);
    }

    @Override
    public Option<DataSize> getMemoryUsage() {
        return client.get(container, "root_pid").map(Integer::parseInt).flatMapO(OfficeProcessHandle::getMemoryUsage);
    }

    @Override
    public void kill() {
        client.destroy(container);
    }

}
