package ru.yandex.chemodan.app.docviewer.adapters.openoffice;

import java.net.ConnectException;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.sun.star.bridge.XBridge;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.XComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficeConnectionWrapper implements ExtendedOpenOfficeConnection {

    private static final Logger logger = LoggerFactory.getLogger(OpenOfficeConnectionWrapper.class);

    private final OpenOfficeConnection delegate;

    public OpenOfficeConnectionWrapper(OpenOfficeConnection delegate) {
        this.delegate = delegate;
    }

    public void connect() throws ConnectException {
        delegate.connect();
    }

    public void disconnect() {
        delegate.disconnect();
    }

    @Override
    public void disconnectQuietly(boolean invalidate) {
        try {
            delegate.disconnect();
        } catch (Throwable exc) {
            logger.error("Unable to disconnect: " + exc, exc);
        }
    }

    public XBridge getBridge() {
        return delegate.getBridge();
    }

    public XComponentContext getComponentContext() {
        return delegate.getComponentContext();
    }

    public OpenOfficeConnection getDelegate() {
        return delegate;
    }

    public XComponentLoader getDesktop() {
        return delegate.getDesktop();
    }

    public XFileIdentifierConverter getFileContentProvider() {
        return delegate.getFileContentProvider();
    }

    public XMultiComponentFactory getRemoteServiceManager() {
        return delegate.getRemoteServiceManager();
    }

    public boolean isConnected() {
        return delegate.isConnected();
    }

}
