package ru.yandex.chemodan.app.docviewer.adapters.poppler;

import lombok.Data;

import ru.yandex.chemodan.app.docviewer.utils.DimensionO;

/**
 * @author akirakozov
 */
@Data
public class ResizeOption {

    public final ResizeType type;
    public final DimensionO size;

    public static ResizeOption scale(DimensionO size) {
        return new ResizeOption(ResizeType.SCALE, size);
    }

    public static ResizeOption bound(DimensionO size) {
        return new ResizeOption(ResizeType.BOUND, size);
    }

    public enum ResizeType {
        /**
         * resize proportionally to given size
         */
        SCALE,
        /**
         * inscribe image in given size (never make image bigger)
         */
        BOUND;
    }

}
