package ru.yandex.chemodan.app.docviewer.adapters.uniconvertor;

import java.util.List;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.docviewer.utils.ExecUtils2;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.jni.JniUtils;
import ru.yandex.misc.thread.ThreadLocalTimeout;

/**
 * @author vlsergey
 * @author akirakozov
 */
public class UniconvertorAdapter {

    private static final String NICE = "nice";

    private static final boolean niceEnabled = JniUtils.isLinux() || JniUtils.isMacOSX();

    @Value("${uniconvertor.renice}")
    private int nice;

    @Value("${uniconvertor.uniconvertor}")
    private String uniconvertor;

    private void addNice(List<String> cmd) {
        if (nice != 0 && niceEnabled) {
            cmd.add(NICE);
            cmd.add("-n");
            cmd.add(Integer.toString(nice));
        }
    }

    public void convert(final InputStreamSource source, final OutputStreamSource target) {
        FileUtils.withFile(source, sourceFile -> FileUtils.withFile(target, targetFile -> {
            convertImpl(sourceFile, targetFile);
        }));
    }

    private void convertImpl(final File2 sourceFile, final File2 targetFile) {
        ThreadLocalTimeout.check();
        FileUtils.checkFileForReading(sourceFile);

        ListF<String> cmd = Cf.arrayList();
        addNice(cmd);
        cmd.add(uniconvertor);
        cmd.add(sourceFile.getAbsolutePath());
        cmd.add(targetFile.getAbsolutePath());

        ExecUtils2.runScript(cmd);
    }

}
