package ru.yandex.chemodan.app.docviewer.archives;

import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.states.MaxFileSizeChecker;
import ru.yandex.chemodan.app.docviewer.states.PasswordProtectedException;
import ru.yandex.commune.archive.ArchiveContext;

/**
 * @author ssytnik
 */
@Value
public class ArchiveContextFactory {

    private final MaxFileSizeChecker fileSizeChecker;

    public ArchiveContext fileExtractingContext(Option<String> password, String pathPrefix) {
        return new ArchiveContext(password, PasswordProtectedException.atCopy(pathPrefix), Option.empty()
        );
    }

    public ArchiveContext archiveListingContext(Option<String> password) {
        return new ArchiveContext(
                password, PasswordProtectedException.atConvert(), Option.of(fileSizeChecker.getMaxArchiveLength()));
    }
}
