package ru.yandex.chemodan.app.docviewer.cleanup;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionDao;

/**
 * @author ssytnik
 */
@AllArgsConstructor
public class SessionCleanup {

    private final SessionDao sessionDao;

    public void cleanup(Instant now, Option<Duration> ageO) {
        cleanup(now, ageO.getOrElse(sessionDao.getSessionTtl()));
    }

    public void removeAll(Instant now) {
        cleanup(now, Duration.ZERO);
    }

    public void cleanup(Instant now, Duration age) {
        Instant maxTimestamp = now.minus(age);
        sessionDao.deleteByTimestampLessBatch(maxTimestamp);
    }

}
