package ru.yandex.chemodan.app.docviewer.cleanup;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.cleanup.bazinga.CleanupRoutines;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;

public class StorageCleanupManager {

    private final CleanupRoutines cleanupRoutines;

    private final YPath tempTablesSubPath;

    public StorageCleanupManager(CleanupRoutines cleanupRoutines, YPath tempTablesSubPath) {
        this.cleanupRoutines = cleanupRoutines;
        this.tempTablesSubPath = tempTablesSubPath;
    }

    public void collectDataForCleanup(LocalDate day) {
        Option<Operation> operationO = cleanupRoutines.collectDocumentsData(day);
        if (!operationO.isPresent()) {
            return;
        }
        operationO.get().awaitAndThrowIfNotSuccess();
        cleanupRoutines.moveTableDataFromTemporaryStorage(tempTablesSubPath.child(day.toString()));
    }
}
