package ru.yandex.chemodan.app.docviewer.cleanup.bazinga;

import org.joda.time.Duration;
import org.joda.time.LocalDate;

import ru.yandex.chemodan.app.docviewer.cleanup.StorageCleanupManager;
import ru.yandex.chemodan.app.docviewer.config.DocviewerTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleWithRetry;
import ru.yandex.misc.time.MoscowTime;

public class CleanupDataGenerationCronTask extends CronTask {

    private final String cronScheduleExecution;

    private final StorageCleanupManager storageCleanupManager;

    public CleanupDataGenerationCronTask(String cronScheduleExecution, StorageCleanupManager storageCleanupManager) {
        this.cronScheduleExecution = cronScheduleExecution;
        this.storageCleanupManager = storageCleanupManager;
    }

    @Override
    public Schedule cronExpression() {
        return new ScheduleWithRetry(new ScheduleCron(cronScheduleExecution, MoscowTime.TZ), 24);
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        LocalDate now = LocalDate.now(MoscowTime.TZ);
        storageCleanupManager.collectDataForCleanup(now);
    }

    @Override
    public TaskQueueName queueName() {
        return DocviewerTaskQueueName.DOCVIEWER_CRON;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(12);
    }
}
