package ru.yandex.chemodan.app.docviewer.cleanup.bazinga;

import java.util.function.Supplier;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.yt.BaseIncrementalLogMrYtRunner;
import ru.yandex.chemodan.util.yt.YqlHelper;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.operations.Operation;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class CleanupRoutines {

    private static final Logger logger = LoggerFactory.getLogger(CleanupRoutines.class);

    private final BaseIncrementalLogMrYtRunner logMrYtRunner;

    private final YtHelper ytHelper;

    private final YqlHelper yqlHelper;

    private final ListF<String> fieldsToSelect;

    private final ListF<String> orderByFields;

    private final Supplier<Integer> daysToDiscoverSupplier;

    private final YPath outputTablePath;

    public CleanupRoutines(BaseIncrementalLogMrYtRunner logMrYtRunner, YtHelper ytHelper, YqlHelper yqlHelper,
            ListF<String> fieldsToSelect, ListF<String> orderByFields, Supplier<Integer> daysToDiscoverSupplier,
            YPath outputTablePath)
    {
        this.logMrYtRunner = logMrYtRunner;
        this.ytHelper = ytHelper;
        this.yqlHelper = yqlHelper;
        this.fieldsToSelect = fieldsToSelect;
        this.orderByFields = orderByFields;
        this.daysToDiscoverSupplier = daysToDiscoverSupplier;
        this.outputTablePath = outputTablePath;
    }

    public Option<Operation> collectDocumentsData(LocalDate date) {
        return logMrYtRunner.retrieve(date, daysToDiscoverSupplier.get());
    }

    public YPath moveTableDataFromTemporaryStorage(YPath tempTable) {
        String yqlTemplate = "USE hahn; " +
                "PRAGMA yt.InferSchema = '1'; " +
                "INSERT INTO `%1$s` " +
                "SELECT %2$s " +
                "FROM `%3$s` " +
                "ORDER BY %4$s ASC";
        if (ytHelper.existsWithRetries(outputTablePath)) {
            logger.debug("Removing the {} table", outputTablePath);
            ytHelper.cypress().remove(outputTablePath);
        }
        yqlHelper.execute(String.format(yqlTemplate, outputTablePath, fieldsToSelect.mkString(", "), tempTable, orderByFields.mkString(", ")));
        ytHelper.cypress().remove(tempTable);
        return outputTablePath;
    }
}
