package ru.yandex.chemodan.app.docviewer.cleanup.bazinga;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CleanupUtils {

    private static final DateTimeFormatter lastAccessDayFormatter = DateTimeFormat.forPattern("yyyy-MM-dd");

    public static boolean isLastAccessDayValid(String lastAccessDay, LocalDate limit) {
        LocalDate lastAccessDate = lastAccessDayFormatter.parseLocalDate(lastAccessDay);
        return !lastAccessDate.isAfter(limit);
    }
}
