package ru.yandex.chemodan.app.docviewer.cleanup.bazinga;

import ru.yandex.chemodan.app.docviewer.yt.YtPathUtils;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;


public class DocumentsCleanupSchedulerTask extends CleanupSchedulerTask<DocumentIdWithLastAccessDay> {

    private static final Logger logger = LoggerFactory.getLogger(DocumentsCleanupSchedulerTask.class);

    private static final String OFFSET_ATTRIBUTE_NAME = "documents_cleanup_offset";

    private final DynamicProperty<Integer> maxProcessorTasksCount =
            new DynamicProperty<>("docviewer-documents-cleanup-max-processors-count", 100);

    private final DynamicProperty<Integer> documentsPerProcessorTask =
            new DynamicProperty<>("docviewer-documents-cleanup-documents-per-processor", 1000);

    private final DynamicProperty<Long> scheduleInterval =
            new DynamicProperty<>("docviewer-documents-cleanup-processor-tasks-schedule-interval-secs", 15L);

    public DocumentsCleanupSchedulerTask(long minutesToRepeat, YtHelper ytHelper, BazingaTaskManager bazingaTaskManager,
                                         DocumentsCleanupPropertiesHolder documentsCleanupPropertiesHolder)
    {
        super(minutesToRepeat, ytHelper, bazingaTaskManager, documentsCleanupPropertiesHolder);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected YPath getTablePathToProcess() {
        return YtPathUtils.getDocumentsCleanupYPath();
    }

    @Override
    protected Class<? extends CleanupProcessorTask<DocumentIdWithLastAccessDay>> getProcessorTaskClass() {
        return DocumentsCleanupProcessorTask.class;
    }

    @Override
    protected int getMaxProcessorTaskCount() {
        return maxProcessorTasksCount.get();
    }

    @Override
    protected String getOffsetAttributeName() {
        return OFFSET_ATTRIBUTE_NAME;
    }

    @Override
    protected YPath getProcessorTablesPathPrefix() {
        return YtPathUtils.getDocumentsCleanupProcessorYPath();
    }

    @Override
    protected int getPerProcessorTaskRowsCount() {
        return documentsPerProcessorTask.get();
    }

    @Override
    protected Class<DocumentIdWithLastAccessDay> getItemsClass() {
        return DocumentIdWithLastAccessDay.class;
    }

    @Override
    protected long getProcessorTasksScheduleIntervalInSecs() {
        return scheduleInterval.get();
    }

    @Override
    protected CleanupProcessorTask<DocumentIdWithLastAccessDay> createProcessorTaskInstance(CleanupProcessorTask.Parameters parameters) {
        return new DocumentsCleanupProcessorTask(parameters);
    }
}
