package ru.yandex.chemodan.app.docviewer.cleanup.bazinga;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.cleanup.ResultsCleanup;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResult;
import ru.yandex.chemodan.app.docviewer.log.DocviewerTskvEvent;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfImageCache;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class ImagesCleanupProcessorTask extends CleanupProcessorTask<ImageIdWithLastAccessDay> {

    private static final Logger logger = LoggerFactory.getLogger(ImagesCleanupProcessorTask.class);

    private ResultsCleanup resultsCleanup;

    private PdfImageCache pdfImageCache;

    public ImagesCleanupProcessorTask(Parameters parameters) {
        super(parameters);
    }

    public ImagesCleanupProcessorTask(YtHelper ytHelper, DocumentsCleanupPropertiesHolder documentsCleanupPropertiesHolder,
            ResultsCleanup resultsCleanup, PdfImageCache pdfImageCache) {
        super(ytHelper, documentsCleanupPropertiesHolder);
        this.resultsCleanup = resultsCleanup;
        this.pdfImageCache = pdfImageCache;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Class<ImageIdWithLastAccessDay> getEntityClass() {
        return ImageIdWithLastAccessDay.class;
    }

    @Override
    protected void processItem(ImageIdWithLastAccessDay item, ProcessingContext processingContext) {
        FileIdLastAccessData documentLastAccessData = processingContext.getFileIdDeletionCache().getO(item.getFileId()).getOrNull();
        if (documentLastAccessData == null) {
            Option<StoredResult> document = resultsCleanup.findPdfFileById(item.getFileId());
            if (document.isPresent()) {
                documentLastAccessData = processingContext.addExistedToCache(item.getFileId(), document.map(resultsCleanup::getCalculatedLastAccessTime).get());
            } else {
                documentLastAccessData = processingContext.addDeletedToCache(item.getFileId());
            }
        }
        if (!documentLastAccessData.isDeleted()) {
            DocviewerTskvEvent.imageSkipped(item.getFileId(), item.getImageSubId(), documentLastAccessData.getLastAccessTime().get())
                    .log();
            return;
        }
        pdfImageCache.cleanupImageSafeById(item.getFileId(), item.getImageSubId(), processingContext.getLastAccessLimitForDeletion());
    }
}
