package ru.yandex.chemodan.app.docviewer.cleanup.bazinga;

import ru.yandex.chemodan.app.docviewer.yt.YtPathUtils;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class ImagesCleanupSchedulerTask extends CleanupSchedulerTask<ImageIdWithLastAccessDay> {

    private static final Logger logger = LoggerFactory.getLogger(ImagesCleanupSchedulerTask.class);

    private static final String OFFSET_ATTRIBUTE_NAME = "images_cleanup_offset";

    private final DynamicProperty<Integer> maxProcessorTasksCount =
            new DynamicProperty<>("docviewer-images-cleanup-max-processors-count", 100);

    private final DynamicProperty<Integer> imagesPerProcessorTask =
            new DynamicProperty<>("docviewer-images-cleanup-documents-per-processor", 1000);

    private final DynamicProperty<Long> scheduleInterval =
            new DynamicProperty<>("docviewer-images-cleanup-processor-tasks-schedule-interval-secs", 15L);

    public ImagesCleanupSchedulerTask(long minutesToRepeat, YtHelper ytHelper, BazingaTaskManager bazingaTaskManager,
            DocumentsCleanupPropertiesHolder documentsCleanupPropertiesHolder)
    {
        super(minutesToRepeat, ytHelper, bazingaTaskManager, documentsCleanupPropertiesHolder);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected YPath getTablePathToProcess() {
        return YtPathUtils.getImagesCleanupYPath();
    }

    @Override
    protected Class<? extends CleanupProcessorTask<ImageIdWithLastAccessDay>> getProcessorTaskClass() {
        return ImagesCleanupProcessorTask.class;
    }

    @Override
    protected int getMaxProcessorTaskCount() {
        return maxProcessorTasksCount.get();
    }

    @Override
    protected String getOffsetAttributeName() {
        return OFFSET_ATTRIBUTE_NAME;
    }

    @Override
    protected YPath getProcessorTablesPathPrefix() {
        return YtPathUtils.getImagesCleanupProcessorYPath();
    }

    @Override
    protected int getPerProcessorTaskRowsCount() {
        return imagesPerProcessorTask.get();
    }

    @Override
    protected Class<ImageIdWithLastAccessDay> getItemsClass() {
        return ImageIdWithLastAccessDay.class;
    }

    @Override
    protected long getProcessorTasksScheduleIntervalInSecs() {
        return scheduleInterval.get();
    }

    @Override
    protected CleanupProcessorTask<ImageIdWithLastAccessDay> createProcessorTaskInstance(CleanupProcessorTask.Parameters parameters) {
        return new ImagesCleanupProcessorTask(parameters);
    }
}
