package ru.yandex.chemodan.app.docviewer.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbAdapter;
import ru.yandex.chemodan.app.docviewer.cleanup.CleanupManager;
import ru.yandex.chemodan.app.docviewer.cleanup.CleanupWorker;
import ru.yandex.chemodan.app.docviewer.cleanup.ResultCleanupConfigurationBean;
import ru.yandex.chemodan.app.docviewer.cleanup.ResultsCleanup;
import ru.yandex.chemodan.app.docviewer.cleanup.SessionCleanup;
import ru.yandex.chemodan.app.docviewer.cleanup.UriCleanup;
import ru.yandex.chemodan.app.docviewer.dao.cleanup.MongoCleanerTaskDao;
import ru.yandex.chemodan.app.docviewer.dao.pdfWarmup.PdfWarmupDao;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResultDao;
import ru.yandex.chemodan.app.docviewer.dao.rights.UriRightsDao;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionDao;
import ru.yandex.chemodan.app.docviewer.dao.uris.StoredUriDao;
import ru.yandex.chemodan.app.docviewer.storages.FileStorage;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.MulcaHttpClient;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfImageCache;
import ru.yandex.chemodan.app.docviewer.web.framework.PreviewHistoryManager;
import ru.yandex.inside.mulca.MulcaClient;

/**
 * @author akirakozov
 */
@Import(DocumentsCleanupSettingsConfiguration.class)
@Configuration
@EnableScheduling
public class CleanupContextConfiguration {

    @Bean
    public CleanupWorker cleanupWorker() {
        return new CleanupWorker();
    }

    @Bean
    public MongoCleanerTaskDao mongoCleanerTaskDao(@Qualifier("mongoDbAdapter") MongoDbAdapter mongoDbAdapter) {
        return new MongoCleanerTaskDao(mongoDbAdapter);
    }

    @Bean
    public CleanupManager cleanupManager(
            PdfImageCache pdfImageCache,
            PdfWarmupDao pdfWarmupDao,
            ResultsCleanup resultsCleanup,
            UriCleanup uriCleanup,
            SessionCleanup sessionCleanup,
            StoredUriDao storedUriDao,
            UriRightsDao uriRightsDao,
            PreviewHistoryManager previewHistoryManager)
    {
        return new CleanupManager(
                pdfImageCache,
                pdfWarmupDao,
                resultsCleanup,
                uriCleanup,
                sessionCleanup,
                storedUriDao,
                uriRightsDao,
                previewHistoryManager);
    }

    @Bean
    public ResultsCleanup resultsCleanup(
            @Qualifier("resultHolder") FileStorage resultHolder,
            StoredResultDao storedResultDao,
            MulcaClient mulcaClient,
            MulcaHttpClient mulcaHttpClient,
            PdfImageCache pdfImageCache,
            StoredUriDao storedUriDao,
            ResultCleanupConfigurationBean resultCleanupConfigurationBean)
    {
        return new ResultsCleanup(resultHolder, storedResultDao, mulcaClient, mulcaHttpClient, pdfImageCache, storedUriDao,
                resultCleanupConfigurationBean);
    }

    @Bean
    public UriCleanup uriCleanup(UriRightsDao uriRightsDao, StoredUriDao storedUriDao) {
        return new UriCleanup(uriRightsDao, storedUriDao);
    }

    @Bean
    public SessionCleanup sessionCleanup(SessionDao sessionDao) {
        return new SessionCleanup(sessionDao);
    }

}
