package ru.yandex.chemodan.app.docviewer.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.docviewer.MimeTypes;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.Converter;
import ru.yandex.chemodan.app.docviewer.convert.ImageToHtmlWrapper;
import ru.yandex.chemodan.app.docviewer.convert.PdfToHtmlWrapper;
import ru.yandex.chemodan.app.docviewer.convert.archive.ArchiveConverter;
import ru.yandex.chemodan.app.docviewer.convert.coreldraw.CorelDrawConverter;
import ru.yandex.chemodan.app.docviewer.convert.djvu.DjvuConverter;
import ru.yandex.chemodan.app.docviewer.convert.doc.DocConverter;
import ru.yandex.chemodan.app.docviewer.convert.doc.DocImageConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.doc.DocxConverter;
import ru.yandex.chemodan.app.docviewer.convert.doc.OdfConverter;
import ru.yandex.chemodan.app.docviewer.convert.epub.EpubConverter;
import ru.yandex.chemodan.app.docviewer.convert.fb2.Fb2Converter;
import ru.yandex.chemodan.app.docviewer.convert.imagemagick.ImageMagickConverter;
import ru.yandex.chemodan.app.docviewer.convert.openoffice.OpenOfficeConverter;
import ru.yandex.chemodan.app.docviewer.convert.openoffice.PresentationConverter;
import ru.yandex.chemodan.app.docviewer.convert.pdf.PdfConverter;
import ru.yandex.chemodan.app.docviewer.convert.text.CsvConverter;
import ru.yandex.chemodan.app.docviewer.convert.text.PgpConverter;
import ru.yandex.chemodan.app.docviewer.convert.text.TextConverter;
import ru.yandex.chemodan.app.docviewer.convert.uniconvertor.UniconvertorConverter;
import ru.yandex.chemodan.app.docviewer.convert.xls.XlsConverter;
import ru.yandex.chemodan.app.docviewer.states.UserErrorReultsChecker;

/**
 * @author akirakozov
 */
@Configuration
public class ConvertersContextConfiguration {

    @Value("${doc.converter.prefer.apachepoi}")
    private boolean docPreferUseApachePoi;
    @Value("${xls.converter.prefer.apachepoi}")
    private boolean xlsPreferApachePoi;

    @PostConstruct
    public void initConvertManager() {
        convertManager().setConverters(converters());
    }

    @Bean
    public TextConverter textConverter() {
        return new TextConverter();
    }

    @Bean
    public PgpConverter pgpConverter() {
        return new PgpConverter();
    }

    @Bean
    public PdfConverter pdfConverter() {
        return new PdfConverter();
    }

    @Bean
    public CorelDrawConverter corelDrawConverter() {
        return new CorelDrawConverter();
    }

    @Bean
    public CsvConverter csvConverter() {
        return new CsvConverter();
    }

    @Bean
    public DocConverter docConverter() {
        return new DocConverter();
    }

    @Bean
    public ImageMagickConverter imageMagickConverter() {
        return new ImageMagickConverter();
    }

    @Bean
    public OpenOfficeConverter openOfficeConverter() {
        return new OpenOfficeConverter();
    }

    @Bean
    public DocxConverter docxConverter() {
        return new DocxConverter();
    }

    @Bean
    public OdfConverter odfConverter() {
        return new OdfConverter();
    }

    @Bean
    public PresentationConverter presentationConverter() {
        return new PresentationConverter();
    }

    @Bean
    public UniconvertorConverter uniconvertorConverter() {
        return new UniconvertorConverter();
    }

    @Bean
    public XlsConverter xlsConverter() {
        return new XlsConverter();
    }

    @Bean
    public ArchiveConverter archiveConverter() {
        return new ArchiveConverter();
    }

    @Bean
    public Fb2Converter fb2Converter() {
        return new Fb2Converter();
    }

    @Bean
    public EpubConverter epubConverter() {
        return new EpubConverter();
    }

    @Bean
    public PdfToHtmlWrapper wrappedPdfConverter() {
        return new PdfToHtmlWrapper(pdfConverter());
    }

    @Bean
    public DjvuConverter djvuConverter() {
        return new DjvuConverter();
    }

    @Bean
    public PdfToHtmlWrapper wrappedDjvuConverter() {
        return new PdfToHtmlWrapper(djvuConverter());
    }

    @Bean
    public PdfToHtmlWrapper wrappedPresentationConverter() {
        return new PdfToHtmlWrapper(presentationConverter());
    }

    @Bean
    public PdfToHtmlWrapper wrappedUniconvertorConverter() {
        return new PdfToHtmlWrapper(uniconvertorConverter());
    }

    @Bean
    public ImageToHtmlWrapper wrappedImageCorelDrawConverter() {
        return new ImageToHtmlWrapper(corelDrawConverter());
    }

    @Bean
    public ImageToHtmlWrapper wrappedImageImageMagickConverter() {
        return new ImageToHtmlWrapper(imageMagickConverter());
    }

    @Bean
    public ConvertManager convertManager() {
        return new ConvertManager();
    }

    @Bean
    public UserErrorReultsChecker userErrorReultsChecker() {
        return new UserErrorReultsChecker();
    }

    @Bean
    public DocImageConvertManager docImageConvertManager() {
        return new DocImageConvertManager();
    }

    @Bean
    public Map<String, List<Converter>> converters() {
        Map<String, List<Converter>> converters = Cf.hashMap();

        converters.put(MimeTypes.MIME_TEXT_PLAIN, Cf.list(textConverter(), openOfficeConverter()));
        converters.put(MimeTypes.MIME_PGP, Cf.list(pgpConverter()));
        converters.put(MimeTypes.MIME_PDF, Cf.list(wrappedPdfConverter()));

        // Temporary disable Uniconverter because of security reasons (DOCVIEWER-2704)
        //converters.put("application/cdr", Cf.<Converter>list(wrappedUniconvertorConverter()));
        converters.put(MimeTypes.APPLICATION_X_CORELDRAW_RIFF_COMPRESSED,
                Cf.list(wrappedImageCorelDrawConverter()));

        converters.put(MimeTypes.MIME_MICROSOFT_WORD, docPreferUseApachePoi ?
                Cf.list(docConverter(), openOfficeConverter()) :
                Cf.list(openOfficeConverter(), docConverter()));
        converters.put(MimeTypes.MIME_MICROSOFT_EXCEL, xlsPreferApachePoi ?
                Cf.list(xlsConverter(), openOfficeConverter()) :
                Cf.list(openOfficeConverter(), xlsConverter()));
        converters.put(MimeTypes.MIME_CSV, Cf.list(csvConverter(), openOfficeConverter()));

        List<String> openOfficeMimeTypes = Cf.list(
                MimeTypes.MIME_RTF,
                MimeTypes.MIME_OPENDOCUMENT_SPREADSHEET,
                MimeTypes.MIME_OPENDOCUMENT_TEXT,
                MimeTypes.MIME_MICROSOFT_OOXML_EXCEL,
                MimeTypes.MIME_MICROSOFT_OOXML_EXCEL_TEMPLATE,
                MimeTypes.MIME_MICROSOFT_OOXML_WORD,
                MimeTypes.MIME_MICROSOFT_OOXML_WORD_TEMPLATE,
                "application/vnd.ms-excel.sheet.macroenabled.12",
                "application/vnd.ms-excel.template.macroenabled.12",
                "application/vnd.ms-excel.sheet.binary.macroenabled.12",
                MimeTypes.MIME_MICROSOFT_SPREADSHEETML,
                MimeTypes.MIME_MICROSOFT_WORDML
        );
        addConverters(converters, openOfficeMimeTypes, Cf.list(openOfficeConverter()));

        List<String> presentationMimeTypes = Cf.list(
                MimeTypes.MIME_MICROSOFT_POWERPOINT,
                MimeTypes.MIME_OPENDOCUMENT_PRESENTATION,
                "application/vnd.oasis.opendocument.graphics",
                MimeTypes.MIME_MICROSOFT_OOXML_POWERPOINT,
                MimeTypes.MIME_MICROSOFT_OOXML_POWERPOINT_TEMPLATE
        );
        converters.put(MimeTypes.MIME_OPENDOCUMENT_TEXT, Cf.list(openOfficeConverter()));
        addConverters(converters, presentationMimeTypes, Cf.list(wrappedPresentationConverter()));

        List<String> imageMimeTypes = Cf.list(
                MimeTypes.MIME_IMAGE_JPEG,
                MimeTypes.MIME_IMAGE_PNG,
                MimeTypes.MIME_IMAGE_GIF,
                MimeTypes.MIME_IMAGE_SVG,
                MimeTypes.MIME_IMAGE_TIFF,
                MimeTypes.MIME_MICROSOFT_BMP,
                MimeTypes.IMAGE_X_IMAGEMAGICK_SUPPORTED,
                MimeTypes.MIME_IMAGE_X_NIKON_NEF,
                MimeTypes.MIME_ADOBE_POSTSCRIPT,
                MimeTypes.MIME_ILLUSTRATOR,
                MimeTypes.MIME_ICO,
                MimeTypes.MIME_ADOBE_PHOTOSHOP
        );
        addConverters(converters, imageMimeTypes,
                Cf.list(wrappedImageImageMagickConverter()));

        addConverters(converters, MimeTypes.MIME_NORMALIZED_ARCHIVES, Cf.list(archiveConverter()));

        converters.put(MimeTypes.MIME_FB2, Cf.list(fb2Converter()));
        converters.put(MimeTypes.MIME_EPUB, Cf.list(epubConverter()));
        converters.put(MimeTypes.MIME_DJVU, Cf.list(wrappedDjvuConverter()));

        return converters;
    }

    private static void addConverters(Map<String, List<Converter>> convertersMap,
            Collection<String> mimeTypes, List<Converter> converters)
    {
        for (String mimeType : mimeTypes) {
            convertersMap.put(mimeType, converters);
        }
    }
}
