package ru.yandex.chemodan.app.docviewer.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.config.conditions.BazingaEnabledCondition;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;

@Import(ChemodanBazingaWorkerContextConfiguration.class)
@Configuration
@Conditional(BazingaEnabledCondition.class)
public class DocviewerBazingaWorkerContextConfiguration {

    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(DocviewerTaskQueueName.DOCVIEWER_CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues() {
        return new BazingaWorkerTaskQueues(Option.of(DocviewerTaskQueueName.DOCVIEWER_CRON),
                Option.of(DocviewerTaskQueueName.DOCVIEWER_REGULAR), Option.empty(), Cf.list());
    }
}
