package ru.yandex.chemodan.app.docviewer.config;


import java.util.regex.Pattern;

import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.propertyeditors.PatternEditor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.boot.ChemodanInitContextConfiguration;

/**
 * @author akirakozov
 */
@Configuration
public class DocviewerInitContextConfiguration {

    @Bean
    @Primary
    public static CustomEditorConfigurer customEditorConfigurer() {
        final CustomEditorConfigurer configurer = new CustomEditorConfigurer();
        configurer.setCustomEditors(ChemodanInitContextConfiguration.getChemodanCustomEditors()
                .plus1(Pattern.class, PatternEditor.class)
        );
        return configurer;
    }

}
