package ru.yandex.chemodan.app.docviewer.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

import ru.yandex.chemodan.util.yt.YqlHelper;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

public class DocviewerYtDataSourceContextConfiguration {

    @Value("${docviewer.yt.http.proxy}")
    private String ytHttpProxyUrl;

    @Value("${docviewer.user.yt.token}")
    private String ytUserOauthToken;

    @Value("${yql.datasource.url}")
    private String url;

    @Value("${docviewer.yql.datasource.user}")
    private String user;

    @Bean
    public Yt docviewerYtClient() {
        return YtUtils.http(ytHttpProxyUrl, ytUserOauthToken);
    }

    @Bean
    public YqlHelper yqlHelper() {
        return new YqlHelper(url, ytUserOauthToken, user);
    }
}
