package ru.yandex.chemodan.app.docviewer.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.zk2.ZkConfiguration;
import ru.yandex.commune.zk2.ZkMediaDevelopmentUtils;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.ZkUtils;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;
import ru.yandex.inside.admin.conductor.ConductorGroup;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.ip.InternetDomainName;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.version.AppName;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */

@Configuration
@Import({
    ZkManagerContextConfiguration.class,
    ConductorContextConfiguration.class
})
public class DvZkContextConfiguration {
    @Value("${zookeeper.conductor.group}")
    private String zookeeperConductorGroup;
    @Autowired
    private Conductor conductor;
    @Autowired
    private EnvironmentType environmentType;

    @Qualifier("zkRoot")
    @Bean
    public ZkPath zkRoot(EnvironmentType environmentType, AppName appName) {
        return ZkUtils.defaultRootPath(appName.serviceName(), environmentType);
    }

    @Bean
    public ZkConfiguration zkConfiguration() {
        if (StringUtils.isNotEmpty(zookeeperConductorGroup)) {
            return new ZkConfiguration(conductor
                    .getGroupHosts(ConductorGroup.parse(zookeeperConductorGroup))
                    .map(InternetDomainName.getF()));
        }

        if (environmentType == EnvironmentType.DEVELOPMENT || environmentType == EnvironmentType.TESTS) {
            return ZkMediaDevelopmentUtils.configuration();
        } else {
            throw new IllegalStateException("You should set zk conductor group");
        }
    }
}
