package ru.yandex.chemodan.app.docviewer.config;

import org.springframework.context.annotation.Bean;

import ru.yandex.chemodan.app.docviewer.utils.html.ConvertToHtmlHelper;
import ru.yandex.chemodan.app.docviewer.utils.html.HtmlPostprocessor;
import ru.yandex.chemodan.app.docviewer.utils.html.HtmlSerializer;
import ru.yandex.chemodan.app.docviewer.utils.html.HtmlSplitter;

/**
 * @author akirakozov
 */
public class HtmlUtilsContextConfiguration {

    @Bean
    public ConvertToHtmlHelper convertToHtmlHelper() {
        return new ConvertToHtmlHelper();
    }

    @Bean
    public HtmlPostprocessor htmlPostprocessor() {
        return new HtmlPostprocessor();
    }

    @Bean
    public HtmlSerializer htmlSerializer() {
        return new HtmlSerializer();
    }

    @Bean
    public HtmlSplitter htmlSplitter() {
        return new HtmlSplitter();
    }
}
