package ru.yandex.chemodan.app.docviewer.config;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.ExternalHttpClient;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.InternalHttpClient;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.MpfsHttpClient;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.MulcaHttpClient;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.http.zora.ZoraConfiguration;
import ru.yandex.chemodan.util.http.zora.ZoraContextConfiguration;
import ru.yandex.chemodan.util.http.zora.ZoraHeader;
import ru.yandex.inside.passport.tvm2.AddServiceTicketInterceptor;
import ru.yandex.inside.passport.tvm2.AddUserTicketInterceptor;
import ru.yandex.inside.passport.tvm2.Tvm2;

/**
 * @author metal
 */
@Configuration
@Import({
        ZoraContextConfiguration.class,
})
public class HttpClientContextConfiguration {
    @Bean
    public InternalHttpClient internalHttpClient(AddServiceTicketInterceptor serviceTicketInterceptor,
                                                 AddUserTicketInterceptor userTicketInterceptor)
    {
        return new InternalHttpClient(serviceTicketInterceptor, userTicketInterceptor);
    }

    @Profile(DocviewerActiveProfiles.EXTERNAL_DOWNLOADER)
    @Bean
    public ZoraConfiguration zoraConfiguration() {
        return new ZoraConfiguration(Cf.list(new ZoraHeader.IgnorCerts(true)));
    }

    @Profile(DocviewerActiveProfiles.EXTERNAL_DOWNLOADER)
    @Bean
    public ExternalHttpClient externalResourceHttpClient() {
        return new ExternalHttpClient();
    }

    @Bean
    public MpfsHttpClient mpfsHttpClient(Tvm2 tvm2) {
        return new MpfsHttpClient(tvm2);
    }

    @Bean
    public MulcaHttpClient mulcaHttpClient(Tvm2 tvm2) {
        return new MulcaHttpClient(tvm2);
    }

    @Bean
    public HttpClient mailMetaHttpClient() {
        return mailMetaHttpClientConfigurator().configure();
    }

    @Bean
    public HttpClient ytMailMetaHttpClient() {
        return ytMailMetaHttpClientConfigurator().configure();
    }

    @Bean
    public HttpClient trackerApiHttpClient() {
        return trackerApiHttpClientConfigurator().createBuilder().build();
    }

    @Bean
    public HttpClient uslugiApiHttpClient(){
        return uslugiApiClientConfigurator().createBuilder().build();
    }

    @Bean
    public HttpClient schoolbookApiHttpClient() {
        return schoolbookApiClientConfigurator().createBuilder().build();
    }

    @Bean
    public HttpClient practicumApiHttpClient(@Qualifier("practicumApiClientConfigurator") HttpClientConfigurator httpClientConfigurator) {
        return httpClientConfigurator.createBuilder().build();
    }

    @Bean
    @OverridableValuePrefix("mail_meta")
    public HttpClientConfigurator mailMetaHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @OverridableValuePrefix("yt_mail_meta")
    public HttpClientConfigurator ytMailMetaHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @OverridableValuePrefix("tracker_api")
    public HttpClientConfigurator trackerApiHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @OverridableValuePrefix("uslugi_api")
    public HttpClientConfigurator uslugiApiClientConfigurator(){
        return new HttpClientConfigurator();
    }

    @Bean
    @OverridableValuePrefix("schoolbook_api")
    public HttpClientConfigurator schoolbookApiClientConfigurator(){
        return new HttpClientConfigurator();
    }

    @Bean
    @OverridableValuePrefix("practicum_api")
    public HttpClientConfigurator practicumApiClientConfigurator(){
        return new HttpClientConfigurator();
    }

}
