package ru.yandex.chemodan.app.docviewer.config;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbAdapter;
import ru.yandex.chemodan.app.docviewer.dao.schedule.MongoScheduledTaskDao;
import ru.yandex.chemodan.app.docviewer.dao.schedule.ScheduledTaskDao;
import ru.yandex.chemodan.app.docviewer.utils.scheduler.PrioritizedThreadPoolExecutor;
import ru.yandex.chemodan.app.docviewer.utils.scheduler.Scheduler;
import ru.yandex.chemodan.app.docviewer.utils.scheduler.local.LocalScheduler;

/**
 * @author akirakozov
 */
public class LocalSchedulerContextConfiguration {
    private static final String convertDocImageName = "convert-doc-image";

    @Value("copier")
    private String copierName;

    @Value("${copier.threads}")
    private int copierThreads;

    @Value("${copier.threadsPriority}")
    private int copierThreadsPriority;

    @Autowired
    @Qualifier("mongoDbAdapter")
    private MongoDbAdapter mongoDbAdapter;

    @Value("convert")
    private String convertName;

    @Value("${convert.threads}")
    private int convertThreads;

    @Value("${convert.threadsPriority}")
    private int convertThreadsPriority;

    @Value("${convert.timeout}")
    private Duration convertTimeout;

    @Value("${convert-doc-image.threads}")
    private int convertDocImageThreads;

    @Bean
    public MongoScheduledTaskDao mongoCopierScheduledTaskDao() {
        return new MongoScheduledTaskDao(copierName, mongoDbAdapter);
    }

    @Bean
    public MongoScheduledTaskDao mongoConvertScheduledTaskDao() {
        return new MongoScheduledTaskDao(convertName, mongoDbAdapter);
    }

    @Bean(autowire = Autowire.BY_NAME)
    public PrioritizedThreadPoolExecutor<String> copierThreadPoolExecuter() {
        return new PrioritizedThreadPoolExecutor<>(copierName, copierThreads, copierThreadsPriority);
    }

    @Bean
    public Scheduler copierScheduler(ScheduledTaskDao copierScheduledTaskDao) {
        return new LocalScheduler(copierScheduledTaskDao, copierThreadPoolExecuter(), convertTimeout);
    }

    @Bean(autowire = Autowire.BY_NAME)
    public PrioritizedThreadPoolExecutor<String> convertThreadPoolExecuter() {
        return new PrioritizedThreadPoolExecutor<>(convertName, convertThreads, convertThreadsPriority);
    }

    @Bean
    public Scheduler convertScheduler(ScheduledTaskDao convertScheduledTaskDao) {
        return new LocalScheduler(convertScheduledTaskDao, convertThreadPoolExecuter(), convertTimeout);
    }

    @Bean(autowire = Autowire.BY_NAME)
    public PrioritizedThreadPoolExecutor<String> convertDocImageThreadPoolExecuter() {
        return new PrioritizedThreadPoolExecutor<>(
                convertDocImageName, convertDocImageThreads, convertThreadsPriority);
    }

    @Bean(autowire = Autowire.BY_NAME)
    public Scheduler convertDocImageScheduler() {
        ScheduledTaskDao dao = new MongoScheduledTaskDao(convertName, mongoDbAdapter);
        return new LocalScheduler(dao, convertDocImageThreadPoolExecuter(), convertTimeout);
    }
}
