package ru.yandex.chemodan.app.docviewer.config;

import com.mongodb.DB;
import com.mongodb.MongoClientOptions;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbAdapter;
import ru.yandex.chemodan.app.docviewer.dao.pdfImage.MongoImageDao;
import ru.yandex.chemodan.app.docviewer.dao.pdfWarmup.MongoPdfWarmupDao;
import ru.yandex.chemodan.app.docviewer.dao.properties.PropertiesDao;
import ru.yandex.chemodan.app.docviewer.dao.results.MongoStoredResultDao;
import ru.yandex.chemodan.app.docviewer.dao.rights.MongoUriRightsDao;
import ru.yandex.chemodan.app.docviewer.dao.sessions.MongoSessionDao;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionDao;
import ru.yandex.chemodan.app.docviewer.dao.uris.MongoStoredUriDao;
import ru.yandex.chemodan.app.docviewer.dao.user.MongoUserDocumentsDao;
import ru.yandex.chemodan.app.docviewer.dao.user.UserDocumentsDao;
import ru.yandex.commune.mongo.schema.MongoSchemaChecker;

/**
 * @author akirakozov
 */
public class MongoDaoContextConfiguration {

    @Bean
    public MongoPdfWarmupDao mongoPdfWarmupDao(
            DB db,
            @Value("${pdf.image.warmup.blockSize}")
            int blockSize,
            @Value("${pdf.image.warmup.ttl}")
            Duration ttl)
    {
        return new MongoPdfWarmupDao(db, blockSize, ttl);
    }

    @Bean
    public MongoDbAdapter mongoDbAdapter(
        @Value("${mongodb.user}") String user,
        @Value("${mongodb.password}") String password,
        @Value("${mongodb.hosts}") String hosts,
        @Value("${mongodb.db}") String db,
        @Value("${mongodb.db.write.concern}") String dbWriteConcern,
        MongoClientOptions mongoClientOptions)
    {
        return new MongoDbAdapter(
                user, password, hosts, db, dbWriteConcern, mongoClientOptions);
    }

    @Bean
    private MongoClientOptions getMongoOptions(
            @Value("${mongodb.connectionsPerHost}") int connectionsPerHost,
            @Value("${mongodb.threadsAllowedToBlockForConnectionMultiplier}") int multiplier,
            @Value("${mongodb.connectTimeout}") int connectTimeout,
            @Value("${mongodb.socketTimeout}") int socketTimeout,
            @Value("${mongodb.socketKeepAlive}") boolean keepAlive)
    {
        return MongoClientOptions.builder()
                .connectionsPerHost(connectionsPerHost)
                .connectTimeout(connectTimeout)
                .socketKeepAlive(keepAlive)
                .socketTimeout(socketTimeout)
                .threadsAllowedToBlockForConnectionMultiplier(multiplier)
                .build();
    }

    @Bean
    public DB mongoDb(@Qualifier("mongoDbAdapter") MongoDbAdapter mongoDbAdapter) {
        return mongoDbAdapter.getDatabase();
    }

    @Bean
    public SessionDao sessionDao() {
        return new MongoSessionDao();
    }

    @Bean
    public MongoStoredUriDao mongoStoredUriDao() {
        return new MongoStoredUriDao();
    }

    @Bean
    public MongoStoredResultDao mongoStoredResultDao() {
        return new MongoStoredResultDao();
    }

    @Bean
    public MongoUriRightsDao mongoUriRightsDao(DB db) {
        return new MongoUriRightsDao(db);
    }

    @Bean
    public UserDocumentsDao userDocumentsDao(DB db) {
        return new MongoUserDocumentsDao(db);
    }

    @Bean
    public MongoImageDao mongoPdfImageDao() {
        return new MongoImageDao();
    }

    @Bean
    public PropertiesDao propertiesDao(DB db) {
        return new PropertiesDao(db);
    }

    @Bean
    public MongoSchemaChecker.SchemaCheckAtStartupPolicy checkAtStartupPolicy() {
        // TODO: check dv mongos and change this
        return MongoSchemaChecker.SchemaCheckAtStartupPolicy.DO_NOTHING;
    }
}
