package ru.yandex.chemodan.app.docviewer.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.monica.election.zk.MonicaZkElectionConfiguration;
import ru.yandex.commune.monica.election.zk.MonicaZkElectionContextConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */

@Configuration
public class MonicaHackedZkElectionConfiguration extends MonicaZkElectionContextConfiguration {

    @Autowired
    private EnvironmentType environmentType;

    @Bean
    @Override
    public MonicaZkElectionConfiguration monicaElectionConfiguration(ZkPath zkRoot) {
        return new MonicaZkElectionConfiguration(new ZkPath("/chemodan/" + environmentId()));
    }

    private String environmentId() {
        if (environmentType != EnvironmentType.DEVELOPMENT) {
            return environmentType.getValue();
        } else {
            return HostnameUtils.localHostname();

        }
    }
}
