package ru.yandex.chemodan.app.docviewer.config;

import java.util.regex.Pattern;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.docviewer.convert.ConvertManager;
import ru.yandex.chemodan.app.docviewer.convert.MimeDetector;
import ru.yandex.chemodan.app.docviewer.convert.pdf.PdfToHtml;
import ru.yandex.chemodan.app.docviewer.copy.Copier;
import ru.yandex.chemodan.app.docviewer.dao.pdfImage.ImageDao;
import ru.yandex.chemodan.app.docviewer.dao.pdfWarmup.PdfWarmupDao;
import ru.yandex.chemodan.app.docviewer.dao.results.StoredResultDao;
import ru.yandex.chemodan.app.docviewer.storages.FileStorage;
import ru.yandex.chemodan.app.docviewer.utils.cache.TemporaryFileCache;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.ImageHelper;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfHelper;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfImageCache;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfRenderTargetTypeHolder;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PdfRenderer;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.PopplerPdfRenderer;
import ru.yandex.chemodan.app.docviewer.utils.pdf.text.PdfEncodingFixer;
import ru.yandex.chemodan.app.docviewer.utils.scheduler.Scheduler;
import ru.yandex.chemodan.app.docviewer.web.backend.StoredResultHelper;
import ru.yandex.chemodan.app.docviewer.web.client.DocviewerForwardClient;

/**
 * @author nshmakov
 */
@Configuration
public class PdfRenderContextConfiguration {

    @Bean
    public PdfHelper pdfImageHelper(
            DocviewerForwardClient docviewerForwardClient,
            PdfWarmupDao pdfWarmupDao,
            Scheduler convertScheduler,
            PdfImageCache pdfImageCache,
            @Value("${pdfimagecache.prerender.forward}")
            int prerenderForward,
            @Value("${pdfimagecache.prerender.backward}")
            int prerenderBackward,
            @Value("${docviewer.get.future.result.timeout}")
            Duration getFutureResultTimeout,
            @Qualifier("resultHolder")
            FileStorage resultHolder,
            StoredResultDao storedResultDao,
            TemporaryFileCache temporaryFileCache,
            @Value("${pdf.image.render.timeout}")
            Duration maxPdfImageRenderDuration)
    {
        return new PdfHelper(
                docviewerForwardClient,
                pdfWarmupDao,
                convertScheduler,
                pdfImageCache,
                prerenderForward,
                prerenderBackward,
                maxPdfImageRenderDuration,
                getFutureResultTimeout,
                resultHolder,
                storedResultDao,
                temporaryFileCache);
    }

    @Bean
    public PdfImageCache pdfImageCache(
            PdfRenderTargetTypeHolder pdfRenderTargetTypeHolder,
            @Qualifier("pdfImagesHolder") FileStorage pdfImagesHolder,
            @Qualifier("pdfRenderer") PdfRenderer pdfRenderer,
            @Qualifier("pdfImageDao") ImageDao pdfImageDao,
            StoredResultHelper storedResultHelper,
            TemporaryFileCache temporaryFileCache
    ) {
        return new PdfImageCache(pdfRenderTargetTypeHolder, pdfImagesHolder, pdfRenderer, pdfImageDao, storedResultHelper, temporaryFileCache);
    }

    @Bean
    public ImageHelper imageHelper(
            @Qualifier("pdfImageDao")ImageDao imageDao,
            @Qualifier("pdfImagesHolder") FileStorage pdfImagesHolder,
            StoredResultHelper storedResultHelper,
            Copier copier,
            ConvertManager convertManager,
            MimeDetector mimeDetector)
    {
        return new ImageHelper(imageDao, pdfImagesHolder, storedResultHelper, copier, convertManager, mimeDetector);
    }

    @Bean
    public PdfRenderer pdfRenderer() {
        return new PopplerPdfRenderer();
    }

    @Bean
    public PdfRenderTargetTypeHolder pdfRenderTargetTypeHolder() {
        return new PdfRenderTargetTypeHolder();
    }

    @Bean
    public PdfEncodingFixer pdfEncodingFixer() {
        PdfEncodingFixer bean = new PdfEncodingFixer();
        bean.setCyrillicFontNames(Cf.list(Pattern.compile("^OfficinaSerif.*C$")));
        return bean;
    }

    @Bean
    public PdfToHtml pdfToHtml() {
        return new PdfToHtml();
    }
}
